/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _MAIN_BUFFER_H_
#define _MAIN_BUFFER_H_

#include <stdio.h>
#include "proto_decl.h"

#define SIZEOF_BUFFER	50000
#define PSIZE		0x2000
#define NEW		0
#define INSERT		1

typedef struct {
	char *top;	/* Debut du buffer */
	char *l_cur;	/* debut du trou (left cursor) */
	char *r_cur;	/* fin du trou (right cursor) */
	char *bottom;	/* fin du buffer */
} Buf;

FCT (void, ClearBuffer, (Buf *buf) );
FCT (void, DeleteBuffer, (Buf *buf) );
FCT (char *, DeleteLines, (Buf *buf, int n, int *len, int *dn) );
FCT (void, DeleteNchar, (Buf *buf, int n) );
FCT (char *, GetBackwardLine, (Buf *buf, int n, int *len) );
FCT (Buf *, GetBuffer, (unsigned int size) );
FCT (int, GetCurrentChar, (Buf *buf, char *c) );
FCT (char *, GetCurrentLine, (Buf *buf, int *len) );
FCT (char *, GetForwardLine, (Buf *buf, int n, int *len) );
FCT (int, GetNcFromLeft, (Buf *buf) );
FCT (int, GetNcFromRight, (Buf *buf) );
FCT (int, GetNewLine, (char *t, int len) );
FCT (int, GetNumberOfLineInBuf, (Buf *buf) );
FCT (void, GetPrevChar, (Buf *buf, char *c) );
FCT (void, HoleToLeft, (Buf *buf) );
FCT (void, HoleToRight, (Buf *buf) );
FCT (void, InsertNchar, (Buf *buf, char *s, int n) );
FCT (int, LoadFileInBuffer, (Buf *buf, FILE *fd, int len, int flag) );
FCT (int, MoveHole, (Buf *buf, int n) );
FCT (int, MoveToLine, (Buf *buf, int n) );
FCT (int, WriteCurrentFile, (Buf *buf, FILE *fd) );

#define RightBuf(buf)	(buf -> r_cur + 1)
#define TopBuf(buf)	(buf -> top)
#define LeftBuf(buf)	(buf -> l_cur - 1)
#define BottomBuf(buf)	(buf -> bottom)

#endif /* _MAIN_BUFFER_H_ */
