/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _MACROS_H_
#define _MACROS_H_

#include "proto_decl.h"

typedef struct mac {
  void * arg;
  FCT(	void, (* f), ()	);
  int last_key;
  int repeat;
  struct mac *next;
} Macro;

FCT (void, StartMacro, (Text *text) );
FCT (void, EndMacro, (Text *text) );
FCT (int, InsideMacro, (Text *text) );
FCT (void, LoadMacro, (Text *text, FCT(void, (* func), ()), void * arg, int repeat) );
FCT (void, ResetMacro, () );
FCT (void, RunMacro, (Text *text, int n) );
FCT (void, DeleteMacro, (Text *text) );

extern int repeat_num;

#endif /* _MACROS_H_ */

