/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _LIST_BOX_H_
#define  _LIST_BOX_H_

#include "proto_decl.h"

#define BOX_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"
#define TITLE_SIZE 128

#define LB_SPACE 10
#define LB_MAP    1
#define LB_UNMAP  2

#define LB_OK "Ok"
#define LB_CANCEL "Cancel"

#define GetListBoxFrame() (l_box.frame)

typedef struct {
	Window		frame, title, w_select, main, ctr, ok, cancel;
	unsigned long 	fg, bg, ts, bs;
	GC		gc;
	XFontStruct 	*font;
	int		height, width, b_width, b_height;
	int             t_height, t_width;
	int             str_x, str_y;
	char            title_text [TITLE_SIZE];
	char            select_text [TITLE_SIZE];
	Text            *text;
	SWin            *scroll;
	Buf             *buf;
	MWin            *mwin;
	int             stat;
	int		select;
	Time		click_time;
	Time		old_click;
} LBox;

FCT (void, ClearListBox, () );
FCT (void, ConfigListBox, (int width, int height) );
FCT (int, DoubleClick, (Time current_t, Time * old_t) );
FCT (int, ExposeListBox, (XEvent *ev) );
FCT (void, FillList, (char *str) );
FCT (void, InitListBox, () );
FCT (void, KillBufferInList, () );
FCT (void, OpenFilesInListBox, () );
FCT (char *, SelectFromListBox, (char *msg) );

#endif /* _LIST_BOX_H_ */
