/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _KILL_BUF_H_
#define _KILL_BUF_H_

#include "proto_decl.h"

/*
**	Le Kill_Buffer est une liste chainee de structure kb decrite si-dessous
**	Pour chaque operation Ctr-K ou Ctr-W dans le texte courant, une structure kb
**	est allouee et les champs, concernant l'objet tue, sont positionnes.
**	Cette structure est ensuite liee a celles deja existantes et devient le
**	kill-buffer courrant (current_kb).C'est tout bete.
*/
typedef struct k_buf {
  char *p;		/* Le buffer */
  unsigned int s_len;	/* Longueur de s dans le buffer */
  unsigned int s_lines;	/* Nb de lignes */
  struct k_buf *next;	/* Les liens */
  struct k_buf *prev;
} kb;

FCT (void, LoadKillBuffer, (Buf *buf) );
FCT (char *, RestoreKillBuf, (int i, int *len, int *dn) );
FCT (void, StoreInKillBuf, (char *s, int len, int n) );

#endif /* _KILL_BUF_H_ */
