/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _FS_BOX_H_
#define  _FS_BOX_H_

#include "proto_decl.h"

#define BOX_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"
#define TITLE_SIZE 128

#define FB_SPACE  10
#define FB_MAP    1
#define FB_UNMAP  2

#define FB_OK "Ok"
#define FB_CANCEL "Cancel"
#define FB_DIR "Directories"
#define FB_FILES "Files"
#define FB_SELECT "Select"
#define FB_INPUT = "File name : "

#define FS_BUFFER_SIZE	10000

typedef struct {
    Window frame, title, dir, ctr, ok, cancel;
    Window dirframe, fileframe, dirtitle, filetitle, dirtext, filetext;
    Window mb_frame;
    unsigned long fg, bg, ts, bs, text_fg, text_bg;
    XFontStruct	*font;
    GC gc;
    int	width, height, t_height, b_width, b_height;
    int str_x, str_y;
    Text *text_dir, *text_file;
    char title_text [TITLE_SIZE];
    Buf	*buf_dir, *buf_file;
    MWin *mwin;
    SWin *scroll_dir, *scroll_file;
    int	select_dir, select_file;
    int	m_width, m_height;
    char *dirname;
    Time click_time;
    Time old_click;
    int stat;
    
} FBox;

#define GetFsBoxFrame() (fs_box.frame)

FCT (int, ButtonFsBox, ( XButtonEvent * ev ));
FCT (void, ConfigFsBox, (int width, int height) );
FCT (int, ExposeFsBox, (XEvent *ev) );
FCT (void, InitFsBox, () );
FCT (char *, SelectFileFromBox, (char *msg) );

#endif /* _FS_BOX_H_ */
