
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

/*
   Les accents en franais :

   Pour obtenir un caractre accentu il suffit de taper le caractre
   (minuscule ou majuscule) puis l'accent (~ pour le trma) :

	a`	:	
	a^	:	

	e'	:	
	e`	:	
	e^	:	
	e~	:	

	i^	:	
	i~	:	

	o^	:	
		
	u`	:	
	u^	:	
	u~	:	


   la cdille se tape avec l'un des trois accents :

	c'	:	
	c`	:	
	c^	:	

    Dans les autres cas l'accent est insr comme n'importe
    quel autre caractre.
*/

{
  create_mode("french");
  
  key_def("french", "'", "french_accent");
  key_def("french", "`", "french_accent");
  key_def("french", "^^", "french_accent");
  key_def("french", "~", "french_accent");

  set_mode_font ("french", "-adobe-new century schoolbook-medium-r-normal--18-180-75-75-p-103-iso8859-1" );
}

int french_code_base(int c)
{
  switch(c) {
  case 'a':
  case 'A':
    return c + 127;
  case 'u':
  case 'U':
    return c + 132;
  default:
    return c + 131;
  }
}

void french_accent()
{
  goto_previous_char();
  
  if (current_char() == 'c'){
    replace_char(231);
    goto_next_char();
    return;
  }
  if (current_char() == 'C') {
    replace_char(199);
    goto_next_char();
    return;
  }

  switch (last_key()) {
    
  case '`' :
    if (strchr("aeuAEU", current_char())) {
      replace_char(french_code_base(current_char()));
      goto_next_char();
      return;
    }
    break;
    
  case '\'' :
    if (strchr("eE", current_char())) {
      replace_char(french_code_base(current_char()) + 1);
      goto_next_char();
      return;
    }
    break;
    
  case '^' :
    if (strchr("aeiouAEIOU", current_char())) {
      replace_char(french_code_base(current_char()) + 2);
      goto_next_char();
      return;
    }
    break;
    
  case '~' :
    if (strchr("eiuEIU", current_char())) {
      replace_char(french_code_base(current_char()) + 3);
      goto_next_char();
      return;
    }
  }
  
  goto_next_char();
  insert_char(last_key());
}
