/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef  _DIAL_BOX_H_
#define  _DIAL_BOX_H_

#include "proto_decl.h"

#define BOX_FONT "-adobe-courier-bold-r-normal--14-140-75-75-m-90-iso8859-1"
#define TITLE_SIZE 128

#define DB_SPACE 10
#define DB_MAP    1
#define DB_UNMAP  2

#define DB_OK "Ok"
#define DB_CANCEL "Cancel"

typedef struct {
	Window		frame, title, main, w_mb, ctr, ok, cancel;
	unsigned long 	fg, bg, ts, bs;
	GC		gc;
	XFontStruct 	*font;
	int		height, width, b_width, b_height;
	int             t_height, t_width;
	int             str_x, str_y;
	char            title_text [TITLE_SIZE];
	int             stat;
} DBox;

#define GetDialBoxFrame() (dial_box.frame)

FCT (void, InitDialogBox, () );
FCT (void, ConfigDialogBox, (int width, int height) );
FCT (int, ExposeDialogBox, (XEvent *ev) );
FCT (char *, GetStringFromDB, (char *prompt, int one_char) );
FCT (int, ButtonDialogBox, (XButtonEvent *ev) );

#endif /* _DIAL_BOX_H_ */
