/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _CTR_PANEL_H_
#define _CTR_PANEL_H_

#include <X11/Xlib.h>

#include "proto_decl.h"

typedef struct {
        Window  w;              /* Fenetre associee */
        void    (* f) ();       /* Callback */
}ButtonWindow;

typedef struct {
        Pixmap          head_pix;
        Pixmap          queue_pix;
        Pixmap          up_pix;
        Pixmap          down_pix;
        Pixmap          np_pix;
        Pixmap          pp_pix;
        GC              mess_gc;
        XFontStruct     *font;
        unsigned long   fg, bg;
        unsigned long   top_shadow, bot_shadow;
} ResourcesButton;
/*
 * La structure de controle en bas de la fenetre d'edition.
 */
typedef struct {
        Window          frame;
        Window          w_stat;
        int             stat;
        Window          mess;
        Window          w_mode;
        Mode            *mode; 
        int             twidth, theight;
        Window          up, down, np, pp;
        Window          head, q;
        char            s [256];
        GC              mess_gc;
        XFontStruct     *font;
        unsigned long   fg, bg, red, green;
        unsigned long   top_sh, bot_sh;
} MWin;

#define BUTTON_W        24
#define MW_SPACE        5
#define NB_BUTTONS      6

#define HeightOfMess() ( BUTTON_W + 4 );
#define ExecButtonFunction(text,i) ( bw [i].f ) ( text );

FCT (void, ClearMessageWindow, (MWin *mwin) );
FCT (void, DeleteControlPanel, (MWin *mwin) );
FCT (void, DisplayMessage, (MWin *mwin, char *) );
FCT (int, ExposeInControlePanel, (Window w, MWin *mwin) );
FCT (void, InitControlRes, (unsigned long fg, unsigned long bg, unsigned long ts, unsigned long bs) );
FCT (int, IsButtonInControl, (Window w) );
FCT (MWin *, MakeControlPanel, (Window w) );
FCT (void, RefreshWindowMode, (MWin *mwin) );
FCT (void, RefreshWindowStatBuf, (MWin *mwin) );
FCT (void, SetButton, (MWin *mwin) );
FCT (void, SetCtrMode, (MWin *mwin, Mode *mode) );
FCT (void, ShowControlPanel, (MWin *mwin, int width, int height) );
FCT (void, DownButton, (Window window) );
FCT (void, UpButton, (Window window) );

#endif /* _CTR_PANEL_H_ */
