/*
** Copyright 1989, 1992 by Lionel Fournigault
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

#ifndef _BM_SEARCH_H_
#define _BM_SEARCH_H_

#include "proto_decl.h"

#define FORWARD	1
#define BACKWARD	-1
#define GLOBAL	1
#define QUERY	2
#define S_MENU	0
#define S_KBD	1

FCT (void, BackwardSearch, (Text *text) );
FCT (int, BmSearch, (char *buf, char *str, int buf_len, int dir ) );
FCT (void, DeleteStrings, () );
FCT (void, ForwardSearch, (Text *text) );
FCT (void, GlobalReplace, (Text *text) );
FCT (int, HandleBackward, (char *str, Text *text) );
FCT (int, HandleForward, (char *str, Text *text) );
FCT (int, HandleGlobal, (Text *text) );
FCT (void, MenuBackwardSearch, (Text *text) );
FCT (void, MenuForwardSearch, (Text *text) );
FCT (void, MenuGlobalReplace, (Text *text) );
FCT (void, MenuQueryReplace, (Text *text) );
FCT (void, QueryReplace, (Text *text) );
FCT (void, ResetPatterns, () );
FCT (void, ResetSearchString, () );
FCT (void, SearchInMan, (Text *text) );
FCT (void, SetPatterns, (char *old, char *new) );

#endif /* _BM_SEARCH_H_ */
