/* extern char *malloc(), *realloc(); */

    /* This file is a transformation of James A. Roskind's C++ grammar */


    /* Copyright (C) 1989,1990 James A. Roskind, All rights reserved.
    This grammar was developed  and  written  by  James  A.  Roskind.
    Copying  of  this  grammar  description, as a whole, is permitted
    providing this notice is intact and applicable  in  all  complete
    copies.   Translations as a whole to other parser generator input
    languages  (or  grammar  description  languages)   is   permitted
    provided  that  this  notice is intact and applicable in all such
    copies,  along  with  a  disclaimer  that  the  contents  are   a
    translation.   The reproduction of derived text, such as modified
    versions of this grammar, or the output of parser generators,  is
    permitted,  provided  the  resulting  work includes the copyright
    notice "Portions Copyright (c)  1989,  1990  James  A.  Roskind".
    Derived products, such as compilers, translators, browsers, etc.,
    that  use  this  grammar,  must also provide the notice "Portions
    Copyright  (c)  1989,  1990  James  A.  Roskind"  in   a   manner
    appropriate  to  the  utility,  and in keeping with copyright law
    (e.g.: EITHER displayed when first invoked/executed; OR displayed
    continuously on display terminal; OR via placement in the  object
    code  in  form  readable in a printout, with or near the title of
    the work, or at the end of the file).  No royalties, licenses  or
    commissions  of  any  kind are required to copy this grammar, its
    translations, or derivative products, when the copies are made in
    compliance with this notice. Persons or corporations that do make
    copies in compliance with this notice may charge  whatever  price
    is  agreeable  to  a  buyer, for such copies or derivative works.
    THIS GRAMMAR IS PROVIDED ``AS IS'' AND  WITHOUT  ANY  EXPRESS  OR
    IMPLIED  WARRANTIES,  INCLUDING,  WITHOUT LIMITATION, THE IMPLIED
    WARRANTIES  OF  MERCHANTABILITY  AND  FITNESS  FOR  A  PARTICULAR
    PURPOSE.

    James A. Roskind
    Independent Consultant
    516 Latania Palm Drive
    Indialantic FL, 32903
    (407)729-4348
    jar@ileaf.com


    ---end of copyright notice---


This file is a companion file to a C++ grammar description file.

*/


/* FILENAME: C.Y */

/*  This  is a grammar file for the dpANSI C language.  This file was
last modified by J. Roskind on 3/7/90. Version 1.00 */




/* ACKNOWLEDGMENT:

Without the effort expended by the ANSI C standardizing committee,  I
would  have been lost.  Although the ANSI C standard does not include
a fully disambiguated syntax description, the committee has at  least
provided most of the disambiguating rules in narratives.

Several  reviewers  have also recently critiqued this grammar, and/or
assisted in discussions during it's preparation.  These reviewers are
certainly not responsible for the errors I have committed  here,  but
they  are responsible for allowing me to provide fewer errors.  These
colleagues include: Bruce Blodgett, and Mark Langley. */

#include "rename.h"
  

#ifdef flex
extern char * yytext;
#else
/* lex */
extern char yytext[];
#endif

# define AUTO 257
# define DOUBLE 258
# define INT 259
# define STRUCT 260
# define BREAK 261
# define ELSE 262
# define LONG 263
# define SWITCH 264
# define CASE 265
# define ENUM 266
# define REGISTER 267
# define TYPEDEF 268
# define CHAR 269
# define EXTERN 270
# define RETURN 271
# define UNION 272
# define CONST 273
# define FLOAT 274
# define SHORT 275
# define UNSIGNED 276
# define CONTINUE 277
# define FOR 278
# define SIGNED 279
# define VOID 280
# define DEFAULT 281
# define GOTO 282
# define SIZEOF 283
# define VOLATILE 284
# define DO 285
# define IF 286
# define STATIC 287
# define WHILE 288
# define IDENTIFIER 289
# define STRINGliteral 290
# define FLOATINGconstant 291
# define INTEGERconstant 292
# define CHARACTERconstant 293
# define OCTALconstant 294
# define HEXconstant 295
# define TYPEDEFname 296
# define ARROW 297
# define ICR 298
# define DECR 299
# define LS 300
# define RS 301
# define LE 302
# define GE 303
# define EQ 304
# define NE 305
# define ANDAND 306
# define OROR 307
# define ELLIPSIS 308
# define MULTassign 309
# define DIVassign 310
# define MODassign 311
# define PLUSassign 312
# define MINUSassign 313
# define LSassign 314
# define RSassign 315
# define ANDassign 316
# define ERassign 317
# define ORassign 318
# define SYNTAX_ERROR 319
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

/* ----end of grammar----*/

#include <stdio.h>

#include "decl.h"

int numlig;
char * yyinfilename = 0;
extern char err_msg[];

yyerror(string)
     char *string;
{
  /* Attention, la forme du message est connue dans smacXcoral,c */

  if (! *err_msg)
    /* Pas une erreur (f)lex */
    if (yyinfilename)
      sprintf(err_msg, "parser error in %s line %d : %s",
	      yyinfilename, numlig, string);
    else
      sprintf(err_msg, "parser error line %d : %s", numlig, string);
}
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 97,
	289, 181,
	-2, 170,
-1, 197,
	40, 173,
	91, 173,
	-2, 172,
-1, 309,
	41, 172,
	44, 172,
	-2, 171,
	};
# define YYNPROD 201
# define YYLAST 945
int yyact[]={

    42,   143,    62,    87,    23,   177,   167,   178,   175,   176,
   264,   128,    52,   129,    24,   155,   181,   182,   157,    85,
    86,   212,   295,    89,    21,    25,    22,   192,    20,    81,
    22,   217,    20,   117,    11,    63,   319,    15,    94,   282,
    11,   125,   128,    90,   129,    10,    92,    93,    11,    22,
    23,    20,   104,   313,   258,   234,   318,   135,    78,    27,
    24,   193,    84,    73,   103,    83,   233,    74,    75,   156,
    76,    25,    88,   139,   266,    79,   263,   100,   171,    71,
   127,   100,   296,   168,    15,   173,   169,   106,    36,   128,
   196,   129,   140,   288,   115,   260,   120,   265,   189,    78,
   107,   327,   321,   275,    73,    37,    83,   210,    74,    75,
   203,    76,   219,    22,   192,    20,    22,   116,     5,    22,
    35,    20,   140,   125,    28,   126,    22,   192,    97,   192,
   127,    97,   101,   138,   137,   130,   276,   297,   290,   131,
   128,   277,   129,   220,   221,    37,   113,    78,    15,   218,
   121,    77,    73,   207,    83,   140,    74,    75,   211,    76,
   226,   331,   192,   297,   100,   103,   183,   100,   184,   204,
   100,   297,   309,    23,   280,   194,   187,   100,   231,   100,
   274,   185,   100,    24,   329,   197,   186,   330,    78,    15,
   166,    38,    77,    73,    25,    83,   200,    74,    75,   136,
    76,    34,     6,   206,    91,   202,   267,   320,   208,   134,
   140,    49,   232,    96,   270,   133,   132,   174,   239,   127,
   204,   191,   248,   249,   242,   243,   244,   245,    98,   246,
   247,   229,   127,    31,   222,   287,   101,    15,   286,   209,
    77,    49,    40,   228,   188,   227,   238,   179,   180,   144,
   145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
    85,    86,    13,   110,   255,    32,   268,   308,   278,   267,
   299,   279,   300,   301,   302,    21,   159,   160,    15,    21,
   124,    77,   122,    95,    23,   172,    59,    16,   304,    54,
    50,    85,    86,   284,    24,   127,    60,   112,    21,   291,
   267,   114,    58,    57,   283,    25,    51,   316,    70,   323,
    56,    53,   305,    55,    21,    89,    33,    85,    86,   315,
   326,   317,   267,    67,    68,    23,   127,    59,   207,   316,
    54,    50,   333,   332,   328,    24,    89,    60,    85,    86,
   103,   325,   298,    58,    57,   314,    25,    51,   127,    70,
   284,    56,    53,   164,    55,    21,    89,   273,    85,    86,
   140,   283,    78,   272,    67,    68,   140,    73,   172,    83,
     2,    74,    75,    39,    76,    59,   112,   292,    54,    50,
   240,   241,     9,   213,   269,    60,   235,    89,    48,    85,
    86,    58,    57,   259,    47,    51,    46,    70,   271,    56,
    53,   140,    55,    21,    89,   230,    85,    86,   140,    45,
   261,   101,    67,    68,   262,    43,    59,   201,    78,    54,
    50,   253,    22,    73,    20,    83,    60,    74,    75,   257,
    76,   256,    58,    57,    19,    12,    51,     8,    70,   142,
    56,    53,   141,    55,    21,    89,    65,    85,    86,    69,
   235,   285,    15,    67,    68,    77,    78,   322,   306,   158,
    66,    73,    72,    83,   225,    74,    75,    78,    76,   250,
   251,   252,    73,   235,    83,    82,    74,    75,    78,    76,
     1,     3,     0,    73,     0,    83,     0,    74,    75,    78,
    76,    41,   259,     0,    73,     0,   162,     7,    74,    75,
     0,    76,     0,     0,    29,    15,     0,   235,   285,     0,
     0,    77,   102,    99,    18,   281,   105,     0,    80,    17,
    18,   123,   324,   118,    14,    17,     0,     0,    18,     0,
    14,     0,    18,    17,     0,    44,     4,    17,    14,     0,
     0,    26,    14,    30,   190,     0,     0,     0,   119,    77,
   119,     0,     0,    17,     0,    17,     0,   204,     0,     0,
    77,     0,     0,   119,   108,   109,     0,   111,    17,     0,
     0,    77,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    77,     0,     0,     0,     0,     0,     0,     0,
    59,     0,     0,    54,    50,     0,     0,     0,     0,     0,
    60,     0,     0,     0,     0,     0,    58,    57,     0,     0,
    51,    64,    70,     0,    56,    53,     0,    55,    21,    89,
     0,    85,    86,     0,     0,     0,     0,    67,    68,     0,
     0,     0,   119,   119,     0,     0,     0,    17,    17,     0,
     0,    23,     0,     0,    23,     0,   205,     0,   195,   198,
   199,    24,     0,     0,    24,     0,     0,     0,     0,     0,
     0,     0,    25,     0,     0,    25,     0,     0,    70,    61,
     0,    21,     0,     0,    21,    89,     0,    85,    86,   161,
   163,   165,     0,    67,    68,     0,   237,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   236,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    70,   254,     0,     0,
     0,     0,    21,    89,     0,    85,    86,    70,     0,     0,
   119,    67,    68,    21,    89,    17,    85,    86,    70,     0,
     0,     0,    67,    68,    21,    89,     0,    85,    86,    70,
     0,     0,     0,    67,    68,    21,    89,     0,    85,    86,
   237,   237,   198,   170,    67,    68,     0,     0,     0,     0,
   236,   236,     0,     0,     0,     0,   165,     0,     0,     0,
     0,     0,     0,   294,     0,     0,     0,     0,    17,   165,
   165,     0,     0,   293,     0,   165,   165,   165,   165,   165,
   165,   165,   165,   165,   165,   165,   165,   165,   165,   165,
     0,   289,   214,   215,   216,   312,     0,   294,   294,     0,
     0,     0,    17,    17,     0,     0,     0,   293,   293,     0,
     0,     0,     0,     0,     0,   223,   224,     0,   307,   310,
   311,     0,   170,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   165,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   165,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   303 };
int yypact[]={

   382, -1000, -1000, -1000, -1000,   -39,     9,   -86,    61,    66,
 -1000,    91, -1000, -1000,     9, -1000, -1000, -1000,     9, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000,    39,   -39,   -86,
 -1000,   -86, -1000,    87,     9, -1000,     9, -1000, -1000,    25,
   155, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,     9,
    -1,    77,    80,   176,   175,   169,   329,   159,    75,    74,
   445,   111, -1000, -1000,   -60,   -48,   -22,   456,   456,   445,
   150,  -300, -1000, -1000, -1000, -1000, -1000, -1000, -1000,   -41,
 -1000, -1000,  -267,   385,    -9, -1000, -1000, -1000,   179, -1000,
  -296,   -55,  -284,   123,   139, -1000, -1000, -1000,     7,   121,
   -32, -1000, -1000,   144,    88,   144, -1000,   434, -1000, -1000,
   -86, -1000, -1000, -1000,   101, -1000, -1000,    76,     9,     9,
    39, -1000,   114, -1000, -1000, -1000,    49, -1000,  -273,  -271,
 -1000, -1000,   445,   445,   445,  -257,   445, -1000, -1000,    53,
   445,   445, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,   445,   445,   445,   423, -1000, -1000,
 -1000, -1000,   445, -1000, -1000, -1000,  -209,   445,   445, -1000,
   364,   137,    79,   445,   445,   445,   445,   445,   445,   445,
   445,   445,   445,   445,   445,   445,   445,   445,  -265,    -1,
 -1000,  -209, -1000, -1000,     2, -1000,    76, -1000, -1000, -1000,
    76, -1000,    97, -1000, -1000, -1000,     9,    86, -1000, -1000,
 -1000, -1000, -1000,   329,   357,   322,   316,   140,    44, -1000,
 -1000, -1000,  -300,    78,    48, -1000,   227,   133,   -41,    -9,
 -1000,   445, -1000, -1000, -1000, -1000,    79,    73,   179,  -296,
   -55,   -55,  -284,  -284,  -284,  -284,   123,   123,   139,   139,
 -1000, -1000, -1000,   194, -1000,     0,   121,    94, -1000,   -10,
 -1000, -1000, -1000,    38, -1000,    97, -1000, -1000, -1000,   329,
 -1000,   329,   329,   329,   445,   445,   445, -1000, -1000, -1000,
 -1000, -1000, -1000,   131,   121,   121,  -265, -1000, -1000, -1000,
  -255, -1000, -1000,   -10,   -14, -1000,    46, -1000,    12, -1000,
  -226, -1000, -1000,   166,    43, -1000,   445, -1000,    76, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,    46,   329,
    42,   445,   143, -1000, -1000, -1000, -1000, -1000,   120, -1000,
   445,   329, -1000, -1000 };
int yypgo[]={

     0,   480,   518,     3,    29,   475,   462,   669,   460,   459,
     2,   458,   457,   611,   449,   283,    78,    38,    47,    46,
   204,    43,    72,    62,    75,    79,   446,    35,   442,   439,
    74,    12,    88,   481,   437,   201,    59,    87,   435,   434,
   431,   429,    54,    39,   117,   421,   417,    97,    22,    76,
    10,     0,   415,   535,   409,   396,   394,   388,   384,   383,
   382,   373,   242,   370,   497,   233,   265,   316,   301,   523,
    45,    33,   287,   513,   267,   544,    90,   213,   262,   244,
    66,    55,   228,   221 };
int yyr1[]={

     0,     2,     3,     4,     4,     5,     5,     6,     6,     6,
     6,     8,     8,     8,     8,     8,     8,     9,    11,     9,
    12,    12,    13,    13,    13,    13,    13,    14,    14,    14,
    14,    14,    14,    15,    15,    17,    17,    17,    17,    18,
    18,    18,    19,    19,    19,    20,    20,    20,    20,    20,
    21,    21,    21,    22,    22,    23,    23,    24,    24,    25,
    25,    26,    26,    27,    27,    10,    10,    28,    29,    29,
    29,    29,    29,    29,    29,    29,    29,    29,    29,     7,
     7,    30,    30,    30,    31,    31,    32,    33,    34,    34,
    35,    38,    39,    39,    39,    40,    40,    41,    41,    42,
    42,    42,    45,    45,    16,    16,    37,    37,    47,    48,
    46,    46,    46,    50,    50,    50,    50,    49,    49,    51,
    51,    51,    51,    51,    51,    58,    52,    59,    52,    60,
    53,    53,    53,    53,    61,    61,    62,    62,    54,    55,
    55,    55,    56,    56,    56,    57,    57,    57,     1,     1,
     1,     1,    63,    63,    63,    63,    63,    63,    65,    65,
    66,    67,    68,    67,    36,    69,    44,    44,    70,    70,
    73,    74,    75,    76,    72,    72,    72,    71,    71,    64,
    64,    79,    78,    78,    78,    43,    43,    43,    77,    77,
    83,    77,    82,    82,    82,    80,    80,    81,    81,    81,
    81 };
int yyr2[]={

     0,     3,     3,     3,     3,     2,     4,     2,     2,     2,
     6,     2,     9,     7,     5,     5,     5,     7,     1,    13,
     2,     6,     2,     5,     5,     5,     9,     3,     3,     3,
     3,     3,     3,     2,     9,     2,     7,     7,     7,     2,
     7,     7,     2,     7,     7,     2,     7,     7,     7,     7,
     2,     7,     7,     2,     7,     2,     7,     2,     7,     2,
     7,     2,     7,     2,    11,     2,     7,     3,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     7,     2,     4,     5,     1,     2,     3,     5,     6,     8,
     2,     2,     3,     3,     3,     2,     7,     2,     6,     3,
     5,     5,     2,     6,     2,     4,     1,     4,     3,     3,
     6,     8,     2,     6,     8,     2,     2,     2,     6,     2,
     2,     2,     2,     2,     2,     1,    10,     1,     8,     3,
     5,     7,     7,     9,     2,     4,     2,     4,     4,    11,
    15,    11,    11,    15,    19,     5,     5,     7,     3,     3,
     3,     1,     5,     7,     5,     7,     7,     9,     2,     4,
     5,     4,     1,     8,     2,     3,     2,     2,     2,     4,
     3,     3,     3,     3,     4,     6,     8,     2,     6,     2,
     4,     1,    11,     6,     8,     2,     2,     2,     3,     5,
     1,     9,     5,     7,     9,     2,     4,     6,     6,     6,
     8 };
int yychk[]={

 -1000,    -1,   -63,   -33,   -53,   -44,   -35,   -64,   -34,   -60,
   -70,   -71,   -38,   -78,   -69,   123,   -72,    -2,   -73,   -39,
    42,   289,    40,   259,   269,   280,   -53,   -36,   -44,   -64,
   -53,   -65,   -66,   -67,   -35,    59,   -32,    44,   125,   -61,
   -62,   -33,   -51,   -52,   -53,   -54,   -55,   -56,   -57,   -35,
   265,   281,   -31,   286,   264,   288,   285,   278,   277,   261,
   271,    -7,   -10,   -27,   -13,   -26,    -8,   298,   299,   -14,
   283,   -25,    -6,    38,    42,    43,    45,   126,    33,   -24,
    -2,    -4,    -5,    40,   -23,   292,   293,    -3,   -22,   290,
   -21,   -20,   -19,   -18,   -17,   -15,   -77,    40,   -82,   -73,
    91,   -44,   -64,   -70,   -71,   -64,   -37,    61,   -53,   -53,
   -65,   -53,   -66,    59,   -68,   -36,   -44,   -71,   -69,   -73,
   -36,   125,   -62,   -33,   125,   -51,   -30,    -4,    43,    45,
    58,    59,    40,    40,    40,   -51,    40,    59,    59,   -31,
    44,   -28,   -29,    61,   309,   310,   311,   312,   313,   314,
   315,   316,   317,   318,   307,    63,    91,    40,    -9,   298,
   299,   -13,    40,   -13,   -15,   -13,    40,   306,   124,    -3,
    -7,   -16,   -35,    94,    38,   304,   305,    60,    62,   302,
   303,   300,   301,    43,    45,    42,    47,    37,   -79,    91,
   -75,   -83,    41,    93,   -30,   -75,   -76,    41,   -75,   -75,
   -76,   -46,   -47,   -10,   123,   -53,   -32,   -71,   -37,   125,
    58,    -4,   292,   -59,    -7,    -7,    -7,   288,   -31,    59,
   -10,   -10,   -25,    -7,    -7,    41,   -10,   -16,   -24,   -23,
    41,    41,   -43,   -80,   -81,   -77,   -69,   -73,   -22,   -21,
   -20,   -20,   -19,   -19,   -19,   -19,   -18,   -18,   -17,   -17,
   -15,   -15,   -15,   -45,    -2,   -30,   -40,   -41,   -42,   -35,
    93,   -77,   -77,   -49,   -50,   -47,   -30,    -3,   -36,   -58,
   -51,    41,    41,    41,    40,    59,    58,    93,    41,    44,
    41,   -15,   -43,   -80,   -81,   -77,    44,    41,    93,   -75,
    44,   -43,   -44,   -69,   -73,   -48,    44,   125,   -49,   -51,
   -51,   -51,   -51,    -7,   -31,   -27,   -11,   -75,   -74,    41,
   -75,   -75,    -2,   308,   -42,   -48,   -50,   -48,    44,   262,
    41,    59,   -12,   -10,   -77,   -48,   -51,    59,   -31,    41,
    44,    41,   -10,   -51 };
int yydef[]={

   151,    -2,   148,   149,   150,     0,     0,     0,     0,    84,
   166,   167,    90,   179,     0,   129,   168,   177,     0,    91,
   165,     1,   170,    92,    93,    94,   152,   106,   164,     0,
   154,     0,   158,   162,     0,    87,     0,    86,   130,    84,
    84,   134,   136,   119,   120,   121,   122,   123,   124,     0,
     0,     0,     0,     0,     0,     0,    84,     0,     0,     0,
    84,    85,    79,    65,    33,    63,    22,     0,     0,     0,
     0,    61,    11,    27,    28,    29,    30,    31,    32,    59,
     7,     8,     9,     0,    57,     3,     4,     5,    55,     2,
    53,    50,    45,    42,    39,    35,   174,    -2,   188,   190,
     0,   169,   180,     0,     0,     0,    88,     0,   153,   155,
     0,   156,   159,   160,     0,   161,   164,   167,     0,     0,
   106,   131,    84,   135,   132,   137,     0,    81,     0,     0,
   127,   138,     0,     0,     0,     0,    84,   145,   146,     0,
     0,     0,    67,    68,    69,    70,    71,    72,    73,    74,
    75,    76,    77,    78,     0,     0,     0,     0,    14,    15,
    16,    23,     0,    24,    25,    33,     0,     0,     0,     6,
     0,     0,   104,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   189,     0,   172,   192,     0,   175,     0,    -2,   178,   183,
     0,   107,     0,   112,   108,   157,     0,     0,    89,   133,
   125,    82,    83,    84,     0,     0,     0,     0,     0,   147,
    80,    66,    62,     0,     0,    13,     0,     0,    60,    58,
    10,     0,   105,   185,   186,   187,   195,   190,    56,    54,
    51,    52,    46,    47,    48,    49,    43,    44,    40,    41,
    36,    37,    38,     0,   102,     0,     0,    95,    97,    99,
   193,   176,   184,     0,   117,     0,   115,   116,   163,    84,
   128,    84,    84,    84,     0,    84,     0,    12,    17,    18,
    26,    34,   196,     0,     0,     0,     0,   182,   194,   191,
     0,   100,   101,   195,   190,   110,     0,   109,     0,   126,
   139,   141,   142,     0,     0,    64,     0,   197,     0,    -2,
   198,   199,   103,    96,    98,   111,   118,   113,     0,    84,
     0,    84,     0,    20,   200,   114,   140,   143,     0,    19,
     0,    84,    21,   144 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"AUTO",	257,
	"DOUBLE",	258,
	"INT",	259,
	"STRUCT",	260,
	"BREAK",	261,
	"ELSE",	262,
	"LONG",	263,
	"SWITCH",	264,
	"CASE",	265,
	"ENUM",	266,
	"REGISTER",	267,
	"TYPEDEF",	268,
	"CHAR",	269,
	"EXTERN",	270,
	"RETURN",	271,
	"UNION",	272,
	"CONST",	273,
	"FLOAT",	274,
	"SHORT",	275,
	"UNSIGNED",	276,
	"CONTINUE",	277,
	"FOR",	278,
	"SIGNED",	279,
	"VOID",	280,
	"DEFAULT",	281,
	"GOTO",	282,
	"SIZEOF",	283,
	"VOLATILE",	284,
	"DO",	285,
	"IF",	286,
	"STATIC",	287,
	"WHILE",	288,
	"IDENTIFIER",	289,
	"STRINGliteral",	290,
	"FLOATINGconstant",	291,
	"INTEGERconstant",	292,
	"CHARACTERconstant",	293,
	"OCTALconstant",	294,
	"HEXconstant",	295,
	"TYPEDEFname",	296,
	"ARROW",	297,
	"ICR",	298,
	"DECR",	299,
	"LS",	300,
	"RS",	301,
	"LE",	302,
	"GE",	303,
	"EQ",	304,
	"NE",	305,
	"ANDAND",	306,
	"OROR",	307,
	"ELLIPSIS",	308,
	"MULTassign",	309,
	"DIVassign",	310,
	"MODassign",	311,
	"PLUSassign",	312,
	"MINUSassign",	313,
	"LSassign",	314,
	"RSassign",	315,
	"ANDassign",	316,
	"ERassign",	317,
	"ORassign",	318,
	"SYNTAX_ERROR",	319,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"_IDENTIFIER : IDENTIFIER",
	"_STRINGliteral : STRINGliteral",
	"constant : INTEGERconstant",
	"constant : CHARACTERconstant",
	"string_literal_list : _STRINGliteral",
	"string_literal_list : string_literal_list _STRINGliteral",
	"primary_expression : _IDENTIFIER",
	"primary_expression : constant",
	"primary_expression : string_literal_list",
	"primary_expression : '(' comma_expression ')'",
	"postfix_expression : primary_expression",
	"postfix_expression : postfix_expression '[' comma_expression ']'",
	"postfix_expression : postfix_expression '(' ')'",
	"postfix_expression : postfix_expression _argument_expression_list",
	"postfix_expression : postfix_expression ICR",
	"postfix_expression : postfix_expression DECR",
	"_argument_expression_list : '(' assignment_expression ')'",
	"_argument_expression_list : '(' assignment_expression ','",
	"_argument_expression_list : '(' assignment_expression ',' argument_expression_list ')'",
	"argument_expression_list : assignment_expression",
	"argument_expression_list : argument_expression_list ',' assignment_expression",
	"unary_expression : postfix_expression",
	"unary_expression : ICR unary_expression",
	"unary_expression : DECR unary_expression",
	"unary_expression : unary_operator cast_expression",
	"unary_expression : SIZEOF '(' type_name ')'",
	"unary_operator : '&'",
	"unary_operator : '*'",
	"unary_operator : '+'",
	"unary_operator : '-'",
	"unary_operator : '~'",
	"unary_operator : '!'",
	"cast_expression : unary_expression",
	"cast_expression : '(' type_name ')' cast_expression",
	"multiplicative_expression : cast_expression",
	"multiplicative_expression : multiplicative_expression '*' cast_expression",
	"multiplicative_expression : multiplicative_expression '/' cast_expression",
	"multiplicative_expression : multiplicative_expression '%' cast_expression",
	"additive_expression : multiplicative_expression",
	"additive_expression : additive_expression '+' multiplicative_expression",
	"additive_expression : additive_expression '-' multiplicative_expression",
	"shift_expression : additive_expression",
	"shift_expression : shift_expression LS additive_expression",
	"shift_expression : shift_expression RS additive_expression",
	"relational_expression : shift_expression",
	"relational_expression : relational_expression '<' shift_expression",
	"relational_expression : relational_expression '>' shift_expression",
	"relational_expression : relational_expression LE shift_expression",
	"relational_expression : relational_expression GE shift_expression",
	"equality_expression : relational_expression",
	"equality_expression : equality_expression EQ relational_expression",
	"equality_expression : equality_expression NE relational_expression",
	"AND_expression : equality_expression",
	"AND_expression : AND_expression '&' equality_expression",
	"exclusive_OR_expression : AND_expression",
	"exclusive_OR_expression : exclusive_OR_expression '^' AND_expression",
	"inclusive_OR_expression : exclusive_OR_expression",
	"inclusive_OR_expression : inclusive_OR_expression '|' exclusive_OR_expression",
	"logical_AND_expression : inclusive_OR_expression",
	"logical_AND_expression : logical_AND_expression ANDAND inclusive_OR_expression",
	"logical_OR_expression : logical_AND_expression",
	"logical_OR_expression : logical_OR_expression OROR logical_AND_expression",
	"conditional_expression : logical_OR_expression",
	"conditional_expression : logical_OR_expression '?' comma_expression ':' conditional_expression",
	"assignment_expression : conditional_expression",
	"assignment_expression : unary_expression _assignment_operator assignment_expression",
	"_assignment_operator : assignment_operator",
	"assignment_operator : '='",
	"assignment_operator : MULTassign",
	"assignment_operator : DIVassign",
	"assignment_operator : MODassign",
	"assignment_operator : PLUSassign",
	"assignment_operator : MINUSassign",
	"assignment_operator : LSassign",
	"assignment_operator : RSassign",
	"assignment_operator : ANDassign",
	"assignment_operator : ERassign",
	"assignment_operator : ORassign",
	"comma_expression : assignment_expression",
	"comma_expression : comma_expression ',' assignment_expression",
	"constant_expression : constant",
	"constant_expression : '+' constant",
	"constant_expression : '-' INTEGERconstant",
	"comma_expression_opt : /* empty */",
	"comma_expression_opt : comma_expression",
	"decl_comma : ','",
	"declaration : declaring_list ';'",
	"declaring_list : type_specifier declarator initializer_opt",
	"declaring_list : declaring_list decl_comma declarator initializer_opt",
	"type_specifier : basic_type_specifier",
	"basic_type_specifier : _basic_type_name",
	"_basic_type_name : INT",
	"_basic_type_name : CHAR",
	"_basic_type_name : VOID",
	"parameter_type_list : parameter_list",
	"parameter_type_list : parameter_list ',' ELLIPSIS",
	"parameter_list : parameter_declaration",
	"parameter_list : parameter_list ',' parameter_declaration",
	"parameter_declaration : type_specifier",
	"parameter_declaration : type_specifier abstract_declarator",
	"parameter_declaration : type_specifier identifier_declarator",
	"identifier_list : _IDENTIFIER",
	"identifier_list : identifier_list ',' _IDENTIFIER",
	"type_name : type_specifier",
	"type_name : type_specifier abstract_declarator",
	"initializer_opt : /* empty */",
	"initializer_opt : '=' initializer",
	"begin_initializer_list : '{'",
	"end_initializer_list : '}'",
	"initializer : begin_initializer_list initializer_list end_initializer_list",
	"initializer : begin_initializer_list initializer_list ',' end_initializer_list",
	"initializer : assignment_expression",
	"initializer_item : begin_initializer_list initializer_list end_initializer_list",
	"initializer_item : begin_initializer_list initializer_list ',' end_initializer_list",
	"initializer_item : constant_expression",
	"initializer_item : _STRINGliteral",
	"initializer_list : initializer_item",
	"initializer_list : initializer_list ',' initializer_item",
	"statement : labeled_statement",
	"statement : compound_statement",
	"statement : expression_statement",
	"statement : selection_statement",
	"statement : iteration_statement",
	"statement : jump_statement",
	"labeled_statement : CASE constant_expression ':'",
	"labeled_statement : CASE constant_expression ':' statement",
	"labeled_statement : DEFAULT ':'",
	"labeled_statement : DEFAULT ':' statement",
	"begin_compound_statement : '{'",
	"compound_statement : begin_compound_statement '}'",
	"compound_statement : begin_compound_statement declaration_list '}'",
	"compound_statement : begin_compound_statement statement_list '}'",
	"compound_statement : begin_compound_statement declaration_list statement_list '}'",
	"declaration_list : declaration",
	"declaration_list : declaration_list declaration",
	"statement_list : statement",
	"statement_list : statement_list statement",
	"expression_statement : comma_expression_opt ';'",
	"selection_statement : IF '(' comma_expression ')' statement",
	"selection_statement : IF '(' comma_expression ')' statement ELSE statement",
	"selection_statement : SWITCH '(' comma_expression ')' statement",
	"iteration_statement : WHILE '(' comma_expression ')' statement",
	"iteration_statement : DO statement WHILE '(' comma_expression ')' ';'",
	"iteration_statement : FOR '(' comma_expression_opt ';' comma_expression_opt ';' comma_expression_opt ')' statement",
	"jump_statement : CONTINUE ';'",
	"jump_statement : BREAK ';'",
	"jump_statement : RETURN comma_expression_opt ';'",
	"external_definition : function_definition",
	"external_definition : declaration",
	"external_definition : compound_statement",
	"external_definition : /* empty */",
	"function_definition : identifier_declarator compound_statement",
	"function_definition : type_specifier identifier_declarator compound_statement",
	"function_definition : old_function_declarator compound_statement",
	"function_definition : type_specifier old_function_declarator compound_statement",
	"function_definition : old_function_declarator old_declaration_list compound_statement",
	"function_definition : type_specifier old_function_declarator old_declaration_list compound_statement",
	"old_declaration_list : old_declaration",
	"old_declaration_list : old_declaration_list old_declaration",
	"old_declaration : old_declaring_list ';'",
	"old_declaring_list : type_specifier declarator",
	"old_declaring_list : old_declaring_list",
	"old_declaring_list : old_declaring_list decl_comma declarator",
	"declarator : identifier_declarator",
	"asterisk : '*'",
	"identifier_declarator : unary_identifier_declarator",
	"identifier_declarator : paren_identifier_declarator",
	"unary_identifier_declarator : postfix_identifier_declarator",
	"unary_identifier_declarator : asterisk identifier_declarator",
	"begin_of_list : '('",
	"end_of_list : ')'",
	"forget_list : ')'",
	"forget_list_if_possible : ')'",
	"postfix_identifier_declarator : paren_identifier_declarator postfixing_abstract_declarator",
	"postfix_identifier_declarator : begin_of_list unary_identifier_declarator forget_list",
	"postfix_identifier_declarator : begin_of_list unary_identifier_declarator forget_list_if_possible postfixing_abstract_declarator",
	"paren_identifier_declarator : _IDENTIFIER",
	"paren_identifier_declarator : begin_of_list paren_identifier_declarator forget_list",
	"old_function_declarator : postfix_old_function_declarator",
	"old_function_declarator : asterisk old_function_declarator",
	"postfix_old_function_declarator : paren_identifier_declarator '('",
	"postfix_old_function_declarator : paren_identifier_declarator '(' identifier_list ')'",
	"postfix_old_function_declarator : begin_of_list old_function_declarator forget_list",
	"postfix_old_function_declarator : begin_of_list old_function_declarator forget_list_if_possible postfixing_abstract_declarator",
	"abstract_declarator : unary_abstract_declarator",
	"abstract_declarator : postfix_abstract_declarator",
	"abstract_declarator : postfixing_abstract_declarator",
	"postfixing_abstract_declarator : array_abstract_declarator",
	"postfixing_abstract_declarator : begin_of_list forget_list",
	"postfixing_abstract_declarator : begin_of_list",
	"postfixing_abstract_declarator : begin_of_list parameter_type_list forget_list",
	"array_abstract_declarator : '[' ']'",
	"array_abstract_declarator : '[' constant_expression ']'",
	"array_abstract_declarator : array_abstract_declarator '[' constant_expression ']'",
	"unary_abstract_declarator : asterisk",
	"unary_abstract_declarator : asterisk abstract_declarator",
	"postfix_abstract_declarator : begin_of_list unary_abstract_declarator forget_list",
	"postfix_abstract_declarator : begin_of_list postfix_abstract_declarator forget_list",
	"postfix_abstract_declarator : begin_of_list postfixing_abstract_declarator forget_list",
	"postfix_abstract_declarator : begin_of_list unary_abstract_declarator end_of_list postfixing_abstract_declarator",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:{ memo_identifier(yytext); } break;
case 2:{ memo_string(yytext); } break;
case 3:{ memo_integer(yytext); } break;
case 4:{ memo_char(yytext); } break;
case 12:{ memo_array_access(); } break;
case 13:{ memo_funcall_0_arg(); } break;
case 14:{ memo_funcall_nargs(); } break;
case 15:{ memo_post_incr(); } break;
case 16:{ memo_post_decr(); } break;
case 17:{ mark_one_arg(); } break;
case 18:{ mark_first_arg(); } break;
case 19:{ mark_some_args(); } break;
case 23:{ memo_pre_incr(); } break;
case 24:{ memo_pre_decr(); } break;
case 25:{ memo_unary_oper(); } break;
case 26:{ memo_sizeof_type();} break;
case 27:{ memo_oper_ampersand(); } break;
case 28:{ memo_oper_asterisk(); } break;
case 29:{ memo_oper_mono_plus(); } break;
case 30:{ memo_oper_mono_minus();} break;
case 31:{ memo_oper_complement();} break;
case 32:{ memo_oper_not(); } break;
case 34:{ memo_cast(); } break;
case 36:{ memo_binary_oper("*"); } break;
case 37:{ memo_binary_oper("/"); } break;
case 38:{ memo_binary_oper("%"); } break;
case 40:{ memo_binary_oper("+"); } break;
case 41:{ memo_binary_oper("-"); } break;
case 43:{ memo_binary_oper("<<"); } break;
case 44:{ memo_binary_oper(">>"); } break;
case 46:{ memo_binary_oper("<"); } break;
case 47:{ memo_binary_oper(">"); } break;
case 48:{ memo_binary_oper("<="); } break;
case 49:{ memo_binary_oper(">="); } break;
case 51:{ memo_binary_oper("=="); } break;
case 52:{ memo_binary_oper("!="); } break;
case 54:{ memo_binary_oper("&"); } break;
case 56:{ memo_binary_oper("^"); } break;
case 58:{ memo_binary_oper("|"); } break;
case 60:{ memo_binary_oper("&&"); } break;
case 62:{ memo_binary_oper("||"); } break;
case 64:{ memo_arith_if(); } break;
case 66:{ memo_assignment(); } break;
case 67:{ memo_identifier(yytext); } break;
case 80:{ memo_comma(); } break;
case 83:{ memo_negate_integer(yytext); } break;
case 84:{ memo_no_comma_expression(); } break;
case 86:{ partial_declaration(); } break;
case 87:{ declaration(); } break;
case 92:{ memo_typedef(Type_Int); } break;
case 93:{ memo_typedef(Type_Char); } break;
case 94:{ memo_typedef(Type_Void); } break;
case 96:{ memo_ellipsis(); } break;
case 99:{ ignored_param(); } break;
case 100:{ ignored_param(); } break;
case 101:{ typed_param(); } break;
case 106:{ mark_no_initializer(); } break;
case 108:{ mark_begin_initializer_list(); } break;
case 109:{ memo_initializer_list(); } break;
case 125:{ memo_case(); } break;
case 127:{ memo_default(); } break;
case 129:{ mark_begin_block(); } break;
case 130:{ memo_empty_block(); } break;
case 131:{ memo_block(); } break;
case 132:{ memo_block(); } break;
case 133:{ memo_block(); } break;
case 139:{ memo_if();} break;
case 140:{ memo_if_else();} break;
case 141:{ memo_switch();} break;
case 142:{ memo_while(); } break;
case 143:{ memo_do_while(); } break;
case 144:{ memo_for(); } break;
case 145:{ memo_continue(); } break;
case 146:{ memo_break(); } break;
case 147:{ memo_return(); } break;
case 148:{ YYACCEPT; } break;
case 149:{ YYACCEPT; } break;
case 150:{ YYACCEPT; } break;
case 151:{ if (*yytext)
				    yyerror(yytext);
				  YYABORT; } break;
case 152:{ memo_make_function_def(); } break;
case 153:{ memo_make_typedef_function_def(); } break;
case 154:{ memo_make_oldfunction_def_without_decllist(); } break;
case 155:{ memo_make_typedef_oldfunction_def_without_decllist(); } break;
case 156:{ memo_make_oldfunction_def(); } break;
case 157:{ memo_make_typedef_oldfunction_def(); } break;
case 160:{ mark_no_initializer(); declaration(); } break;
case 162:{ mark_no_initializer(); } break;
case 165:{ mark_asterisk(); } break;
case 170:{ mark_begin_of_list(); } break;
case 171:{ end_of_list(); } break;
case 172:{ forget_list(); } break;
case 173:{ forget_list_if_possible(); } break;
case 181:{ mark_begin_identifier_list(); } break;
case 182:{ end_identifier_list(); } break;
case 188:{ array_abstract_declarator(); } break;
case 189:{ memo_empty_function_parameter_type_list(); } break;
case 190:{ mark_begin_function_parameter_type_list(); } break;
case 191:{ end_function_parameter_type_list(); } break;
case 192:{ memo_array_decl_without_dim(); } break;
case 193:{ memo_array_decl_dim(); } break;
case 194:{ memo_array_decl_dim(); } break;
	}
	goto yystack;		/* reset registers in driver code */
}
