
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "While.h"
#include "list.h"
#include "control.h"
#include "comma.h"

/*
  fct = make_while
  info = [test, body]
*/

While * make_while(l)
     List * l;
{
  List ** m = (List **) l->info;
  Instruction * test = MAKE(m[0]);
  int prev_in_iter = in_iteration;
  int prev_in_switch = in_switch;
  Instruction * body;
  While * result;

  in_iteration = 1;
  in_switch = 0;
                  
  body = (m[1]->fct == (InstrFct) no_comma_expression) ? 0 : MAKE(m[1]);
  /* ne pas mettre le MAKE dans While__While car il peut modifier in_iteration
     et l'ordre d'execution des arguments est quelconque */
  result = While__While(test, body, in_iteration != 1);
  
  in_iteration = prev_in_iter;
  in_switch = prev_in_switch;
  
  free(l);
  free(m);

  return result;
}

/*
  fct = make_while
  info = [body, test]
*/

While * make_do_while(l)
     List * l;
{
  List ** m = (List **) l->info;
  int prev_in_iter = in_iteration;
  int prev_in_switch = in_switch;
  Instruction * test = MAKE(m[1]);
  Instruction * body;
  While * result;

  in_iteration = 1;
  in_switch = 0;
  
  body = (m[0]) ? MAKE(m[0]) : 0;
  /* ne pas mettre le MAKE dans DoWhile__DoWhile car il peut modifier
     in_iteration et l'ordre d'execution des arguments est quelconque */
  result = DoWhile__DoWhile(test, body, in_iteration != 1);
  
  in_iteration = prev_in_iter;
  in_switch = prev_in_switch;
                  
  free(l);
  free(m);
  
  return result;
}

