
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _stack_h
#define _stack_h

#include "fctdecl.h"
#include "Object.h"
#include "error.h"

typedef struct {
  Object * Pointer;
  Object * End;

  Object * _memory;
} Stack;


FCT (Stack *, Stack__Stack,(unsigned)		);
FCT (Object, Stack__Push,(Stack *, Object)	);
FCT (void, Stack__ReserveStruct,(Stack *, int)	);
FCT (void, Stack_Empty,(Stack *)		);

#define Stack__Top(s)	(s->Pointer[-1])

     
/* La pile des variables locales */

extern Stack * Var_Stack;
extern Object * Frame_Pointer;

#define Stack_Pointer Var_Stack->Pointer
#define End_Stack Var_Stack->End
#define push_loc(x) Stack__Push(Var_Stack, x)
#define reserve_struct_loc(x) Stack__ReserveStruct(Var_Stack, x)

extern unsigned Stack_Size;

extern void Init_Stack();
extern void Reinit_Stack();
     
#endif
