
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "stack.h"
#include "mem.h"

Stack * Stack__Stack(size)
     unsigned size;
{
  Stack * this = (Stack *) Malloc(sizeof(Stack));
  
  this->Pointer = this->_memory =
      (Object *) RTCMalloc(size * sizeof(Object));
  this->End = this->_memory + size;

#if RUNTIMECHECK
  forbit_RTCfree(this->Pointer);
#endif

  return this;
}


Object Stack__Push(this, obj)
     Stack * this;
     Object obj;
{
  if (this->Pointer >= this->End)
    Error_Full_Stack();

  *this->Pointer++ = obj;

  return obj;
}

/* Pour les vecteur locaux, empile l'adresse du mot suivant en pile
   puis reserve de la place, ainsi l'evaluation d'une variable locale
   de type tableaux est indentique a l'evaluation d'une variable locale
   `normale' */

void Stack__ReserveStruct(this, size)
     Stack * this;
     int size;
{
  Object * pt = this->Pointer;
  
  if ((this->Pointer = pt + size + 1) >= this->End)
    Error_Full_Stack();
  *pt = (Object) (pt + 1);
}


/* vide la pile */

void Stack_Empty(this)
     Stack * this;
{
  this->Pointer = this->_memory;
}


/* La pile des variables locales */

unsigned Stack_Size = 1024;

Stack * Var_Stack;
Object * Frame_Pointer;


void Init_Stack()
{
  Var_Stack = Stack__Stack(Stack_Size);
}

void Reinit_Stack()
{
  Stack_Empty(Var_Stack);
}
