
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _mem_h
#define _mem_h

#include <stdlib.h>

#include "fctdecl.h"

extern FCT ( void *, Malloc,(int)	);
extern FCT ( void *, Calloc,(int, int)	);
extern FCT ( void , Free,(void *)	);
extern FCT ( char *, Strdup,(char *)	);

#ifndef RUNTIMECHECK
     
#define RTCMalloc	Malloc
#define RTCCalloc	Calloc
#define RTCStrdup	Strdup

#else

extern char * Address_Min;
extern char * Address_Char_Max;
extern char * Address_Int_Max;
extern char * Address_Pointer_Max;

extern FCT ( void, RTCFree,(void *)		);
extern FCT ( void *, RTCMalloc,(int)		);
extern FCT ( void *, RTCCalloc,(int, int)	);

extern FCT ( void, forbit_RTCfree,(void *)	);
     
extern FCT ( char *, init_rtcmalloc,(int)	);

/* strdup is not defined on all system (!!) */
     
extern FCT ( char *, stringdup,(char *)		);
     
#endif
  
#endif
