
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <stdio.h>
#include <pwd.h>

#include "smac.h"
#include "error.h"

extern FILE * yyin;

char *ExpandTildeName ( name )
    char *name;
{
    struct passwd *pwd;
    char *home;
    char *p = name + 1;
    static char  buf [256];
    
    if ( name [1] == '/' ) {        /* c'est moi */
	if ( (home = (char *) getenv ( "HOME" )) == 0 )
	  return name;
	(void) strcpy ( buf, home );
	(void) strcat ( buf, name + 1 );
    }
    else { /* c'est un autre */
	int save;
	
	while ( *p && *p != '/' ) p++;
	save = *p;
	*p = 0;
	pwd = getpwnam ( name + 1 );
	*p = save;
	if (  pwd ) {
	    (void) strcpy ( buf, pwd ->  pw_dir);
	    (void) strcat ( buf, p );
	}
	else
	  return name;
    }
    return buf;
}

void main()
{
#ifdef RUNTIMECHECK
  char * m = init_smac(1024, 15);	/* taille pile = 1024,
					   tas = 2^15 octets */
  if (m) {
    fputs(m, stderr);

    exit(1);
  }
#else
  init_smac(1024);			/* taille pile */
#endif

  (void) signal(SIGINT, error_ctrl_c);
  
  /* Lecture de stdin jusqu'a la fin de fichier */

  for (;;) {
    if (! (setjmp(come_back))) {
      load_file();
      /* ya eu une erreur de lecture */
      if (*err_msg)
	Error(err_msg);
    }
    /* ya eu erreur */
    putchar('\n');
  }
}
