
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _list_h
#define _list_h

#include "fctdecl.h"
#include "Instruction.h"

typedef struct _List {
  FCT(Instruction *, (*fct), (struct _List *));
  void * info;
  struct _List * previous;
  struct _List * next;
} List;

typedef FCT(Instruction *, (*InstrFct), (List *));
     
FCT(	List *, List__List,(InstrFct fct, void * info)		);
FCT(	List *, List__AddLast,(List * list, List * newcell)		);
FCT(	List *, List__InsertBefore,(List * list, List * newcell)	);
FCT(	List *, List__InsertAfter,(List * list, List * newcell)	);
FCT(	List *, List__PopLast,(List * list, List ** memolast)		);
FCT(	List *, List__Remove,(List * list, List * last)		);
     
#define List__Delete 		free
     
#define AddLast(x, y)		x = List__AddLast(x, y)
#define InsertAfter(x, y)	x = List__InsertAfter(x, y)
#define PopLast(x, y)		x = List__PopLast(x, (List **) &y)


extern FCT(int, list_length,(List *)	);

#define MAKE(x)			(((x)->fct)(x))
     
extern List * Memo;

#endif
