
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "list.h"

/* allocation */

List * List__List(fct, info)
     InstrFct fct;
     void * info;
{
  List * result = (List *) Malloc(sizeof(List));

  result->fct = fct;
  result->info = info;

  result->previous = 0;
  result->next = 0;

  return result;
}


/* Ajoute en fin de liste */

List * List__AddLast(endlist, newcell)
     List * endlist;
     List * newcell;
{
  if ((newcell->previous = endlist) != 0)
    endlist->next = newcell;

  return newcell;
}


/* Insere avant la cellule */

List * List__InsertBefore(list, newcell)
     List * list;
     List * newcell;
{
  if ((newcell->previous = list->previous) != 0)
    list->previous->next = newcell;
  list->previous = newcell;
  newcell->next = list;

  return newcell;
}


/* Insere apres la cellule */

List * List__InsertAfter(list, newcell)
     List * list;
     List * newcell;
{
  newcell->previous = list;
  newcell->next = list->next;
  list->next = newcell;

  return newcell;
}


/* Retire et memorise le dernier element */

List * List__PopLast(list, memolast)
     List *  list;
     List ** memolast;
{
  List * result = list->previous;
  
  *memolast = list;
  list->previous = 0;
  if (result)
    result->next = 0;
  
  return result;
}


/* Retire la liste du chainage qui l'entoure, retourne la derniere liste*/

List * List__Remove(list, last)
     List * list;
     List * last;
{
  if (list->previous)
    if ((list->previous->next = list->next) != 0)
      list->next->previous = list->previous;
    else
      return list->previous;
  else
    if (list->next)
      list->next->previous = 0;
    else
      return 0;

  return last;
}


int list_length(l)
     List * l;
{
  int result;

  for (result = 0; l; result += 1, l = l->next)
    ;

  return result;
}


/* */

List * Memo = 0;
