
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <string.h>

#include "indirection.h"
#include "list.h"
#include "operator.h"
#include "Const.h"
#include "error.h"

/*   ((cast) *place) opername value; */

Instruction * indirection_assignment(place, lvalue, opername, cast)
     List * place;
     List * lvalue;
     char * opername;
     Type * cast;
{
  Instruction * p = MAKE((List *) place->info);
  Instruction * value = MAKE(lvalue);
  Type * ptype = GetExprType(p);
  Type * type = GetExprType(value);
  FCT( Object,(*convert),(Object) );

  free(place);

  if (! Type__IsaPointer(ptype))
    Error("illegal indirection (not a pointer)");

  if (! cast) cast = Type__Pointed_Type(ptype);

  if (Type__IsaArray(cast))
    Error("illegal assignment (*&array = ...)");
  
  if (*opername != '=') {
    Type * valtype;
    FCT( Object,(*bfct),(Object, Object, int));

    opername[strlen(opername) - 1] = 0;			/* enleve = */
    bfct = find_modifbinary_oper(opername, cast, type, &valtype);
    free(opername);

    if ((convert =
	 (FCT(Object,(*),(Object))) Type__Convertible(valtype, cast))
	== (FCT( Object,(*),(Object))) Type__Convertible)
      convert = 0;
    else if (! convert)
      error_incompatible_types(cast, valtype, 
			       "incompatible type in assignment");
    
    return (Instruction *)
      IndirectionModify__IndirectionModify(p, value, bfct, cast, convert);
  }
  
  if ((convert =
       (FCT(Object,(*),(Object))) ExprType__Convertible(value, cast))
      == (FCT( Object,(*),(Object))) Type__Convertible)
    convert = 0;
  else if (! convert)
    error_incompatible_types(cast, GetExprType(value), 
			     "incompatible type in assignment");
  
  free(opername);
  
  return (Instruction *)
    IndirectionAssignment__IndirectionAssignment(p, value, cast, convert);
}


/*   ((cast) *place)++/--; */

Instruction * indirection_post_incrdecr(place, value, cast)
     List * place;
     int    value;
     Type * cast;
{
  Instruction * p = MAKE((List *) place->info);
  Type * ptype = GetExprType(p);
  Type * type = Type__Pointed_Type(ptype);
  FCT( Object,(*convert),(Object) );
  FCT( Object,(*bfct),(Object, Object, int));

  free(place);

  if (! Type__IsaPointer(ptype))
    Error("illegal indirection (not a pointer)");

  if (! cast) cast = type;

  if (Type__IsaArray(cast))
    Error("illegal assignment (*(&array)++/--)");
  
  {
    Type * dummy;
    
    bfct = find_modifbinary_oper("+", cast, Type_Int, &dummy);
  }

  if ((convert = (FCT(Object,(*),(Object))) Type__Convertible(type, cast))
      == (FCT( Object,(*),(Object))) Type__Convertible)
    convert = 0;
  else if (! convert)
    error_incompatible_types(cast, type, "incompatible type in assignment");
    
  return (Instruction *)
    IndirectionPostIncrDecr__IndirectionPostIncrDecr
      		(p, value, bfct, cast, convert);
}
