
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "If.h"
#include "list.h"

/* fct = make_if
   info = List ** [test, iftrue, ifalse / 0] */

If * make_if(l)
     List * l;
{
  List ** m = (List **) l->info;
  If * result;

  result = If__If(MAKE(m[0]), MAKE(m[1]), (m[2]) ? MAKE(m[2]) : 0);
		  
  free(l);
  free(m);
  
  return result;
}


/* fct = make_arith_if
   info = List ** [test iftrue ifalse] */

ArithIf * make_arith_if(l)
     List * l;
{
  List ** m = (List **) l->info;
  ArithIf * result;

  result = ArithIf__ArithIf(MAKE(m[0]), MAKE(m[1]), MAKE(m[2]));
		  
  free(l);
  free(m);
  
  return result;
}
