
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <stdio.h>

#include "identifier.h"
#include "Identifier.h"
#include "function.h"
#include "list.h"
#include "error.h"

/* Retourne ce qui correspond au nom donne : une variable locale,
   globale ou une fonction */

Object make_identifier(l)
     List * l;
{
  char * name = (char *) l->info;

  free(l);
    
  {
    Object result;
    
    if ((result = HashTable__Search(DynamicVarsHashTable, (Object) name)) != 0) {
      free(name);
      return result;
    }
  }

  {
    Identifier * id;
    
    if ((id = find_identifier(name)) != 0) {
      free(name);
      if (Identifier__FunctionDef(id))
	return (Object) Identifier__FunctionDef(id);
      return (Object) Identifier__GlobalVar(id);
    }

    sprintf(err_msg, "%s unknown", name);
    free(name);
    Error(err_msg);

    return 0;			/* pour le compilo */
  }
}
