
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _hash_h
#define _hash_h

#include "fctdecl.h"
#include "word.h"

typedef struct _HashItem {
  Object _key;
  Object _data;
  struct _HashItem * _next;
} HashItem;

extern FCT(HashItem *, HashItem__HashItem,
	   (Object key, Object data, HashItem * next));

#define HashItem__Key(x)	(x)->_key
#define HashItem__Data(x)	(x)->_data
    
#define HashItem__Delete	free

typedef struct {
  HashItem ** _table;
  unsigned _n_entries;
  unsigned _size;
  FCT (unsigned int, (*_hfct), (Object));
  FCT (int, (*_cfct), (Object, Object));
} HashTable;

extern FCT(void, HashTable_Iter,(HashTable *, HashItem **, HashItem ***) );
     
extern FCT( HashTable *, HashTable__HashTable,(unsigned size, int str)   );
extern FCT( Object, HashTable__Search, (HashTable *, Object)		 );
extern FCT( void, HashTable__Add, (HashTable *, Object, Object)		 );
extern FCT( Object, HashTable__Remove, (HashTable *, Object)		 );
extern FCT( void, HashTable__Empty, (HashTable *)			 );

#endif
