
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "For.h"
#include "list.h"
#include "control.h"
#include "comma.h"

/*
  fct = make_for
  info = [init, test, modif, body]
*/

For * make_for(l)
     List * l;
{
  List ** m = (List **) l->info;
  Instruction * init = (m[0]->fct == no_comma_expression) ? 0 : MAKE(m[0]);
  Instruction * test = (m[1]->fct == no_comma_expression) ? 0 : MAKE(m[1]);
  Instruction * modif = (m[2]->fct == no_comma_expression) ? 0 : MAKE(m[2]);
  int prev_in_iter = in_iteration;
  int prev_in_switch = in_switch;
  Instruction * body;
  For * result;

  in_iteration = 1;
  in_switch = 0;
  
  body = (m[3]->fct == no_comma_expression) ? 0 : MAKE(m[3]);
  /* ne pas mettre le MAKE dans For__For car il peut modifier in_iteration
     et l'ordre d'execution des arguments est quelconque */
  result = For__For(init, test, modif, body, in_iteration != 1);
  
  in_iteration = prev_in_iter;
  in_switch = prev_in_switch;
  
  free(l);
  free(m);

  return result;
}
