
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _error_h
#define _error_h

#include <setjmp.h>
#include <memory.h>

#include "fctdecl.h"
#include "word.h"

extern char * Function_Name;
extern char err_msg[];
extern int Debug_Mode;

typedef struct _memo_functions_called {
  Object last_function_called;
  struct _memo_functions_called * previous;
} memo_functions_called;

extern memo_functions_called * Last_Function_Called;

extern jmp_buf come_back;

extern FCT( void, Error_Full_Stack,()		);
extern FCT( void, Internal_Error,(char *)	);
extern FCT( void, Fatal_Error,(char *)		);
extern FCT( void, Error,(char *)		);

extern FCT( void, printf_function_called,()	);
extern FCT( void, Reinit_Error,()		);

extern int Showed_Stack_Size;


#define COPY_ENV(dest, src) memcpy((char*) dest, (char*) src, sizeof(dest))

typedef enum { NO_JMP,
	       JMP_RETURN,
	       JMP_CONTINUE, JMP_BREAK,
	       JMP_ERROR}
	JMP_TYPE;

/* Le traitement du ctrl-c */

#include <signal.h>

extern int During_Evaluation;
extern FCT( void, accept_ctrl_c,()	);
extern FCT( void, error_ctrl_c,(int)	);
extern FCT( void, clear_ctrl_c,()	);

#define ignore_ctrl_c() 		During_Evaluation = 0


#endif
