
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <stdio.h>

#include "control.h"
#include "Control.h"
#include "error.h"
#include "list.h"

jmp_buf current_env;
Object current_result;

int in_iteration = 0;
int in_switch = 0;


Instruction * make_control(l)
     List * l;
{
  JMP_TYPE type = (l->info) ? JMP_CONTINUE : JMP_BREAK;

  free(l);
  
  if ((! in_iteration) &&
      ((! in_switch) || (type == JMP_CONTINUE))) {
    sprintf(err_msg, "illegal %s", (type == JMP_BREAK) ? "break" : "continue");
    Error(err_msg);
  }

  if ((! in_switch) || (type == JMP_CONTINUE))
    in_iteration += 1;
  
  return (Instruction *) Control__Control(type);
}

void Reinit_Control()
{
  in_iteration = 0;
  in_switch = 0;
}
