
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Comma.h"
#include "list.h"

/*
  fct = no_comma_expression
  info = 0
  */

Instruction * no_comma_expression(l)
   List * l;
{
  free(l);

  return (Instruction *) CommaExpression__CommaExpression(0, 0, 0);
}


/*
  fct = make_comma
  info = (char **) [nbre_elt, elt1, ... eltn] avec elti : List *, nbre_elt > 0
*/

Instruction * make_comma(l)
     List * l;
{
  int ndisc = (int) ((char **) l->info)[0] - 1;
  Instruction ** discarded =
    (Instruction **) Malloc(ndisc * sizeof(Instruction *));
  List ** p = ((List **) l->info) + 1;
  Instruction * result;
  int index;

  for (index = 0; index != ndisc; index += 1)
    discarded[index] = MAKE(p[index]);

  result = (Instruction *)
    CommaExpression__CommaExpression(discarded, MAKE(p[index]), ndisc);
  
  free(l->info);
  free(l);

  return result;
}
