
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Cast.h"
#include "list.h"
#include "Function.h"
#include "Var.h"

/*
   fct = make_cast
   info = List ** [Type * type, List * expr]
   */

Instruction * make_cast(l)
     List * l;
{
  Type * desiredtype = ((Type **) l->info)[0];
  Instruction * expr = MAKE(((List**) l->info)[1]);
  ConvFct convert = ExprType__Convertible(expr, desiredtype);

  free(l);
  
  if (convert != AlreadyConvertible)
    if (convert ||
	IsaFunction(expr) || IsaGlobalVar(expr) || IsaLocalVar(expr))
      return (Instruction *) Cast__Cast(expr, desiredtype, convert);
    else
      /* on fait comme si .. on peut faire un effet de bord sur l'objet */
      GetExprType(expr) = desiredtype;

  return expr;
}
