
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Instruction.h"
#include "Block.h"
#include "list.h"
#include "declaration.h"
#include "function.h"
#include "error.h"

/* fct = make_block
   info = (List *) 1ere expression, les suivantes par next */

Instruction * make_block(body)
     List * body;
{
  int length;

  {
    List * l = (List *) body->info;

    free(body);
    body = l;
  }
  
  length = list_length(body);

  if ((length == 1) &&
      (body->fct != (InstrFct) make_declaration) &&
      (body->fct != (InstrFct) make_function_declaration))
    /* Une seul instruction : pas besoin de block */
    return MAKE(body);

  {
    Instruction ** instrs;
    Instruction ** pinstrs;
    List * begin = body;
    int ndecl = 0;
    
    pinstrs = instrs = (Instruction **) Malloc(length * sizeof(Instruction *));
    
    while (body) {
      List * next = body->next;

      /* on compte les decl car les instructions qui ne
	 sont pas des declarations sont desallouees, il
	 n'est plus alors possible de se demander si ce
	 sont ou non des declaration et retrouver le nom
	 des vars a retirer */
      if (body->fct == (InstrFct) make_function_declaration)
	if (! Return_Value_Type)
	  Error("Declaration in eval form");
	else {
	  MAKE(body);
	  ndecl += 1;
	  length -= 1;		/* pas d'instruction associee */
	}
      else {
	if (body->fct == (InstrFct) make_declaration)
	  if (! Return_Value_Type)
	    Error("Declaration in eval form");
	  else
	    ndecl += 1;
	*pinstrs++ = MAKE(body);
      }
      
      body = next;
    }

    if (ndecl)
      remove_varloc(begin, ndecl);
    
    return (Instruction *) Block__Block(length, instrs);
  }
}
