
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "While.h"
#include "stack.h"
#include "control.h"

/* WHILE */

static inherit_instruction_function_vector
  while_inherit_instruction_function_vector;

While * While__While(test, body, hasbreakcont)
     Instruction * test;
     Instruction * body;
     int hasbreakcont;
{
  While * this = (While *) Malloc(sizeof(While));

  Instruction_Constructor
    (while_inherit_instruction_function_vector, this, Type_Void);
       
  if (GetExprType(test) == Type_Void)
    Error("while (void) ..\n");
  else
    this->_test = test;
  
  this->_body = body;
  this->_hasbreakcont = hasbreakcont;

  return this;
}


static Object While__Eval(this)
     While * this;
{
  Instruction * test = this->_test;
  Instruction * body = this->_body;
  
  if (body)
    if (this->_hasbreakcont) {
      Object * stackpointer = Stack_Pointer;
      jmp_buf save_env;
      
      COPY_ENV(save_env, current_env);
      while(Eval(test)) {
	switch (setjmp(current_env)) {
	case NO_JMP :
	  Eval(body);
	  break;
	case JMP_RETURN:
	  longjmp(save_env, JMP_RETURN);
	case JMP_CONTINUE:
	  Stack_Pointer = stackpointer;
	  goto etiq_cont;
	case JMP_BREAK:
	  Stack_Pointer = stackpointer;
	  goto etiq_break;
	case JMP_ERROR :
	  longjmp(save_env, JMP_ERROR);
	}
      etiq_cont: ;
	COPY_ENV(current_env, save_env);	/* pour le test */
      }
    etiq_break:
      COPY_ENV(current_env, save_env);
    }
    else
      while(Eval(test)) Eval(body);
  else
    while(Eval(test)) ;

  return 0;
}


/* DO WHILE */

static inherit_instruction_function_vector
  dowhile_inherit_instruction_function_vector;

While * DoWhile__DoWhile(test, body, hasbreakcont)
     Instruction * test;
     Instruction * body;
     int hasbreakcont;
{
  While * this = (While *) Malloc(sizeof(While));

  Instruction_Constructor
    (dowhile_inherit_instruction_function_vector, this, Type_Void);
       
  if (GetExprType(test) == Type_Void)
    Error("do .. while(void)\n");
  else
    this->_test = test;
  
  this->_body = body;
  this->_hasbreakcont = hasbreakcont;

  return this;
}


static Object DoWhile__Eval(this)
     While * this;
{
  Instruction * test = this->_test;
  Instruction * body = this->_body;
  
  if (body)
    if (this->_hasbreakcont) {
      Object * stackpointer = Stack_Pointer;
      jmp_buf save_env;
      
      COPY_ENV(save_env, current_env);
      do {
	switch (setjmp(current_env)) {
	case NO_JMP :
	  Eval(body);
	  break;
	case JMP_RETURN:
	  longjmp(save_env, JMP_RETURN);
	case JMP_CONTINUE:
	  Stack_Pointer = stackpointer;
	  goto etiq_cont;
	case JMP_BREAK:
	  Stack_Pointer = stackpointer;
	  goto etiq_break;
	case JMP_ERROR :
	  longjmp(save_env, JMP_ERROR);
	}
      etiq_cont: 
	COPY_ENV(current_env, save_env);	/* pour le test */
      } while (test);
    etiq_break:
      COPY_ENV(current_env, save_env);
    }
    else
      do Eval(body); while(Eval(test));
  else
    while(Eval(test)) ;

  return 0;
}


void Init_While()
{
  while_inherit_instruction_function_vector._Eval = (EvalFct) While__Eval;
  dowhile_inherit_instruction_function_vector._Eval = (EvalFct) DoWhile__Eval;
}
