
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Var_h
#define _Var_h

#include "Instruction.h"


/* LocalVar : les variables locales */

typedef struct {
  Inherit_Instruction;
  
  char * _name;
  int _position;
} LocalVar;

extern FCT (LocalVar *, LocalVar__LocalVar,
	    (char * nom, int position, Type * t));

typedef struct {
  Inherit_Instruction;
  
  int _position;
  Instruction * _value;
  FCT( Object,(* _convert),(Object));
} LocalVarAssignment;

extern FCT (LocalVarAssignment *, LocalVarAssignment__LocalVarAssignment,
	    (LocalVar *, Instruction *, Type *)	);

typedef struct {
  Inherit_Instruction;
  
  int _position;
  Instruction * _value;
  FCT( Object,(* _convert),(Object));
} LocalVarPostIncrDecr;

extern FCT (LocalVarPostIncrDecr *, LocalVarPostIncrDecr__LocalVarPostIncrDecr,
	    (LocalVar *, Instruction *, Type *)	);

typedef struct {
  Inherit_Instruction;
  
  int _position;
} LocalVarRef;

extern FCT (LocalVarRef *, LocalVarRef__LocalVarRef, (LocalVar * var));

extern FCT (int, IsaLocalVar,(Instruction *)				);


void Init_LocalVar();

	    
/* GlobalVar : les variables globales */

typedef struct {
  Inherit_Instruction;

  char * _name;
  Object _value;
} GlobalVar;

extern FCT (GlobalVar *, GlobalVar__GlobalVar, (char *, Type *, Object)	);

typedef struct {
  Inherit_Instruction;
  
  Object * _pvalue;
  Instruction * _value;
  FCT( Object,(* _convert),(Object));
} GlobalVarAssignment;

extern FCT (GlobalVarAssignment *, GlobalVarAssignment__GlobalVarAssignment,
	    (GlobalVar *, Instruction *, Type *)	);

typedef struct {
  Inherit_Instruction;

  Object _value;
} GlobalVarRef;

extern FCT (GlobalVarRef *, GlobalVarRef__GlobalVarRef, (GlobalVar *)	);

typedef struct {
  Inherit_Instruction;
  
  Object * _pvalue;
  Instruction * _value;
  FCT( Object,(* _convert),(Object));
} GlobalVarPostIncrDecr;

extern FCT (GlobalVarPostIncrDecr *,
	    GlobalVarPostIncrDecr__GlobalVarPostIncrDecr,
	    (GlobalVar *, Instruction *, Type *)	);

extern FCT (int, IsaGlobalVar,(Instruction *)				);

void Init_GlobalVar();

#ifdef RUNTIMECHECK
#define GlobalVar__Value(gv)	*((Object *) (gv)->_value)
#else
#define GlobalVar__Value(gv)	(gv)->_value
#endif
    
#endif
