
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Type_h
#define _Type_h

/* Doit etre place avant les includes */

typedef enum { T_Builtin, T_Pointer, T_Array, T_Function } type_of_type;

typedef struct {
  void * _name_or_pointed;
  type_of_type _type;
  int _sizeof;
} Type;

typedef struct {
  int _nbre_arg;
  Type ** _argtypes;
  Type * _valtype;
} TypeFunction;

#include "fctdecl.h"
#include "hash.h"
#include "word.h"
#include "Instruction.h"

typedef FCT(Object, (*ConvFct), (Object)	);
     
extern FCT( Type *, Type__Type,(void * subinfo, type_of_type tot,
				int size_of));

extern FCT( int, Type__Equal,(Type *, Type *)		);
extern FCT( void, Type__Print,(Type *, char *)		);
extern FCT( Object, Type__Mask,(Type *)			);
extern FCT( ConvFct, Type__Convertible,(Type *, Type *)	);
extern FCT( ConvFct, ExprType__Convertible,(Instruction *, Type *)	);

#define AlreadyConvertible	((ConvFct) Type__Convertible)
     
extern FCT( char, int2char,(int)	);
extern FCT( int, char2int,(int)	);

#define Type__IsBuiltin(t)	((t)->_type == T_Builtin)
#define Type__IsaPointer(t)	(((t)->_type == T_Pointer) ||		\
       				 ((t)->_type == T_Array)   ||		\
       				 ((t)->_type == T_Function))
#define Type__IsaArray(t)	((t)->_type == T_Array)
#define Type__IsaFunction(t)	((t)->_type == T_Function)
     
#define Type__Sizeof(t)		((t)->_sizeof)
#define Type__Pointed_Type(t)	((Type *) (t)->_name_or_pointed)
#define Type__Name(t)		((char *) (t)->_name_or_pointed)
#define Type__Function(t)	((TypeFunction *) (t)->_name_or_pointed)

#define TypeFunction__ValType(tf) 	((tf)->_valtype)
#define TypeFunction__ArgType(tf, rank) ((tf)->_argtypes[rank])
#define TypeFunction__NbreArg(tf) 	((tf)->_nbre_arg)

#define Type__SizeInWord(t)	\
       ((Type__Sizeof(t) + sizeof(void *) - 1) / sizeof(void *))

/**/
     
extern Type * Type_Int;
extern Type * Type_Char;
extern Type * Type_Void;

extern Type * Type_String;
extern Type * Type_PInt;

extern FCT( Type *, find_type, (char * name)	);
extern FCT( void, error_incompatible_types,(Type * t1, Type * t2, char * msg)	);

void Init_type();
     
#endif
