
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Switch.h"
#include "error.h"
#include "function.h"
#include "control.h"
#include "stack.h"

static inherit_instruction_function_vector
  switch_inherit_instruction_function_vector;

Switch * Switch__Switch(key, exprs, cases, ncases, defaultindice)
     Instruction * key;
     Instruction ** exprs;
     int * cases;
     int ncases;
     int defaultindice;
{
  Switch * this = (Switch *) Malloc(sizeof(Switch));

  Instruction_Constructor
    (switch_inherit_instruction_function_vector, this, Type_Void);

  this->_key = key;
  this->_exprs = exprs;
  this->_cases = cases;
  this->_ncases = ncases;
  this->_default_indice = defaultindice;

  return this;
}

static Object Switch__Eval(this)
     Switch * this;
{
  Instruction ** exprs = 0;

  /* Cherche l'entree correspondante
     Les clefs pourraient etre triees pour faire une recherche dico */
  {
    Object key = Eval(this->_key);
    int * cases = this->_cases;
    int ncases = this->_ncases;
    int icase;
    
    for (icase = 0; icase != ncases; icase += 2)
      if (key == cases[icase]) {
	/* C'est elle ! */
	exprs = &this->_exprs[cases[icase + 1]];
	break;
      }
  }

  if (! exprs)
    if (this->_default_indice != -1)
      exprs = &this->_exprs[this->_default_indice];
    else
      return 0;

  /* On execute les expressions a partir de la 1ere
     correspondante, il y a obligatoirement break final */
  
  {
    Object * stackpointer = Stack_Pointer;
    jmp_buf save_env;

    COPY_ENV(save_env, current_env);
    
    for(;;) {
      JMP_TYPE jmptype;
      
      switch (jmptype = (JMP_TYPE) setjmp(current_env)) {
      case NO_JMP :
	Eval(*exprs);
	exprs += 1;
	break;
      case JMP_BREAK:
	Stack_Pointer = stackpointer;
	goto etiq_break;
      default:
	longjmp(save_env, jmptype);
      }
    }
  etiq_break:
    COPY_ENV(current_env, save_env);
    return 0;
  }
}

void Init_Switch()
{
  switch_inherit_instruction_function_vector._Eval = (EvalFct) Switch__Eval;
}
