
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Return.h"
#include "error.h"
#include "function.h"
#include "control.h"

static inherit_instruction_function_vector
  return_inherit_instruction_function_vector;

Return * Return__Return(value)
     Instruction * value;
{
  Return * this = (Return *) Malloc(sizeof(Return));
  Type * type = (value) ? GetExprType(value) : Type_Void;
  ConvFct convert;

  if (! Function_Name)
    Error("return at top level");
  if (! value)
    this->_convert = 0;
  else if (! (convert = ExprType__Convertible(value, Return_Value_Type)))
    Error(  (type == Type_Void)
	  ? "the function return value"
	  : (Return_Value_Type == Type_Void)
	  ? "the function return no value"
	  : "incompatible return type");
  else if (convert != AlreadyConvertible)
    this->_convert = convert;
  else
    this->_convert = 0;
      
  Instruction_Constructor
    (return_inherit_instruction_function_vector, this, type);

  this->_value = value;

  return this;
}

static Object Return__Eval(this)
     Return * this;
{
  if (this->_value)
    if (this->_convert)
      current_result = (this->_convert)(Eval(this->_value));
    else
      current_result = Eval(this->_value);

  longjmp(current_env, JMP_RETURN);
}

void Init_Return()
{
  return_inherit_instruction_function_vector._Eval = (EvalFct) Return__Eval;
}
