
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _RefDeref_h
#define _RefDeref_h

#include "Instruction.h"

typedef struct {
  Inherit_Instruction;

  Instruction * _pointer;
  FCT ( Object, (*_deref), (Object)	);
} Indirection;

extern FCT(Indirection  *,Indirection__Indirection,(Instruction *, Type *) );

     
typedef struct {
  Inherit_Instruction;

  Instruction * _pointer;
  Instruction * _value;
  FCT ( Object, (*_convert), (Object)	);
  FCT ( Object, (*_refassign), (Object, Object)	);
} IndirectionAssignment;

extern FCT(IndirectionAssignment  *,
	   IndirectionAssignment__IndirectionAssignment,
	   (Instruction *, Instruction *, Type *, FCT2(Object,(*),(Object) )));

typedef struct {
  Inherit_Instruction;

  Instruction * _pointer;
  Instruction * _value;
  FCT ( Object, (*_convert), (Object)	);
  FCT ( Object, (*_deref), (Object)	);
  FCT ( Object, (*_refassign), (Object, Object)	);
  FCT( Object,(* _bfct),(Object, Object, int)	);
  int _size;
} IndirectionModify;

extern FCT(IndirectionModify  *,
	   IndirectionModify__IndirectionModify,
	   (Instruction *, Instruction *,
	    FCT2( Object,(*),(Object, Object, int)),
	    Type *, FCT2(Object,(*),(Object) )));

typedef struct {
  Inherit_Instruction;

  Instruction * _pointer;
  int _value;
  FCT ( Object, (*_convert), (Object)	);
  FCT ( Object, (*_deref), (Object)	);
  FCT ( Object, (*_refassign), (Object, Object)	);
  FCT( Object,(* _bfct),(Object, Object, int)	);
  int _size;
} IndirectionPostIncrDecr;

extern FCT(IndirectionPostIncrDecr  *,
	   IndirectionPostIncrDecr__IndirectionPostIncrDecr,
	   (Instruction *, int, FCT2( Object,(*),(Object, Object, int)),
	    Type *, FCT2(Object,(*),(Object) )));

extern void Init_RefDeref();

#endif
