
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


/* Doit etre laisse au tout debut */

#include "Type.h"

#ifndef _Instruction_h
#define _Instruction_h

#include "fctdecl.h"
#include "Object.h"
#include "mem.h"

/* Les fonctions definies pour chaque sous type d'Instruction :
     
     Eval evalue l'expression et rend sa valeur

     IsaConst retourne 1 pour les constantes builtin, sinon 0
*/

typedef FCT( Object, (*EvalFct), (void *) );
     
typedef struct {
  EvalFct _Eval;
} inherit_instruction_function_vector;


/* A inclure dans les definitions des `sous types' pour heriter */

#define Inherit_Instruction						\
  inherit_instruction_function_vector * instruction_functions;		\
  int _isa_const;							\
  Type * _expr_type

  
/* Les appels des fonctions virtuelles */

#define Eval(i)		((*((i)->instruction_functions->_Eval))(i))

/* Les constructeurs herites */

#define Instruction_Constructor(v, i, t)	\
  i->instruction_functions = &v;		\
  i->_expr_type = t;				\
  i->_isa_const = 0

#define Const_Constructor(v, c, t)		\
  c->instruction_functions = &v;		\
  c->_expr_type = t;				\
  c->_isa_const = 1
 
/* Le type `pure' Instruction */
  
typedef struct _Instruction {
  Inherit_Instruction;
} Instruction;


#define GetExprType(i)	((i)->_expr_type)
#define IsaConst(i)	((i)->_isa_const)
  
#endif
