
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Identifier_h
#define _Identifier_h

#include "fctdecl.h"
#include "Function.h"
#include "Var.h"
#include "hash.h"

typedef struct {
  char * _name;
  Function * _functiondef;
  GlobalVar * _globalvar;
} Identifier;

#define Identifier__Name(i)		((i)->_name)
#define Identifier__FunctionDef(i)	((i)->_functiondef)
#define Identifier__GlobalVar(i)	((i)->_globalvar)

extern FCT( Identifier *, Identifier__Identifier,
	   	(char *, Function *, GlobalVar *));

extern FCT ( Identifier *, Get_Identifier,(char * name)	);
     
#define find_identifier(name) 	\
	((Identifier *) HashTable__Search(IdentifierHashTable, (Object) name))

extern HashTable * IdentifierHashTable;

extern void Init_Identifier();

#endif
