
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Identifier.h"

HashTable * IdentifierHashTable;
  
Identifier * Identifier__Identifier(name, functiondef, globalvar)
     char * name;
     Function * functiondef;
     GlobalVar * globalvar;
{
  Identifier * this = (Identifier *) Malloc(sizeof(Identifier));

  this->_name = name;
  this->_functiondef = functiondef;
  this->_globalvar = globalvar;

  HashTable__Add(IdentifierHashTable, (Object) name, (Object) this);
  
  return this;
}

/* Retourne l'identifier correspondant au nom, le cree si besoin */

Identifier * Get_Identifier(name)
     char * name;
{
  Identifier * result;

  if ((result = find_identifier(name)) != 0)
    return result;

  return Identifier__Identifier(name, 0, 0);
}

/**/

void Init_Identifier()
{
  IdentifierHashTable = HashTable__HashTable(30, 1);
}
