
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _FunctionCall_h
#define _FunctionCall_h

#include "Instruction.h"
#include "Function.h"

/* Appel d'une fonction utilisateur */

typedef struct {
  Inherit_Instruction;

  Function * _function;
  Instruction ** _args;
  int _narg;
} FunctionCall;

extern FCT( FunctionCall *, FunctionCall__FunctionCall,
	   (Function *, Instruction **, int narg)	);


/* Appel d'une fonction builtin
   
   Utilise directement la meme structure
   au lieu de passer par un heritage */

extern FCT(FunctionCall *, BuiltinFunctionCall__BuiltinFunctionCall,
	   (Function *, Instruction **, int narg, Type *)	);

/* Appel d'une fonction calculee */

typedef struct {
  Inherit_Instruction;

  Instruction * _function;
  Instruction ** _args;
  int _narg;
} CalculateFunctionCall;

extern FCT( CalculateFunctionCall *,
	    CalculateFunctionCall__CalculateFunctionCall,
	   	(Instruction *, Instruction **, int narg)	);



#if defined(RUNTIMECHECK) || defined(XCORAL)

/* Pseudo argument place en dernier pour sortir en erreur s'il est evalue,
   utilise pour les fonctions n'ayant pas un nombre fixe d'argument */

typedef struct {
  Inherit_Instruction;

  Function * _function;
  int _narg;
} NotEnoughArg;

extern FCT( NotEnoughArg *, NotEnoughArg__NotEnoughArg,(Function *, int)  );
extern FCT( int, IsaNotEnoughArg,(Instruction *) );
     
#endif

#ifdef XCORAL
extern FCT( void, call_user_function_from_xcoral,(Function *, int, int *) );
extern FCT( void, call_builtin_function_of_xcoral,(Function *, int) );
#endif
     
void Init_FunctionCall();

#endif
