
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Function_h
#define _Function_h

/* L'objet fonction */

#include "Instruction.h"

typedef struct {
  Inherit_Instruction;

  char * _name;
  int _nbre_arg;
  union {
    FCT( Object, (* _builtin_def), (Instruction **) );
    Instruction * _user_def;
  } _def;
  Type ** _argtypes;
  Type * _valtype;
  Object * _masks;
  int _profile_count;
} Function;

extern FCT (Function *, Function__Function,
	    (char * nom, Type * valtype, int narg,
	     Type ** argtypes, Object def));

#define Function__Name(f)		((f)->_name)
#define Function__ValType(f) 		((f)->_valtype)
#define Function__ArgType(f, rank) 	((f)->_argtypes[rank])
#define Function__NbreArg(f) 		((f)->_nbre_arg)
#define Function__IsBuiltin(f)		(! (f)->_masks)
#define Function__BuiltinDef(f)		((f)->_def._builtin_def)
#define Function__UserDef(f)		((f)->_def._user_def)

extern FCT(void, Function__UpdateDef,(Function * this, Instruction *));
extern FCT(void, Function__VerifyNotActive,(Function * this));

void Init_Function();

/**/
  
typedef struct {
  Inherit_Instruction;

  Function * _func;
} UndefinedFunctionCall;

extern FCT( UndefinedFunctionCall *,
	   UndefinedFunctionCall__UndefinedFunctionCall,
	   (Function * func));

extern FCT ( int, IsaFunction,(Instruction *)		);
extern FCT ( int, Function__IsUndefined,(Function *)	);
extern FCT ( int, IsaPointerToFunction,(void *)		);
     
void Init_UndefinedFunctionCall();
  
#endif
