
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Declaration.h"
#include "stack.h"

static inherit_instruction_function_vector
  declaration_inherit_instruction_function_vector;

Declaration * Declaration__Declaration(initval, convert, sizeinword)
     Instruction * initval;
     FCT( Object,(*convert),(Object));
     int sizeinword;
{
  Declaration * this = (Declaration *) Malloc(sizeof(Declaration));

  Instruction_Constructor
    (declaration_inherit_instruction_function_vector, this, Type_Void);

  this->_init_value = initval;
  this->_convert = convert;
  this->_sizeinword = sizeinword;

  return this;
}

static Object Declaration__Eval(this)
     Declaration * this;
{
  if (this->_sizeinword)
    reserve_struct_loc(this->_sizeinword);
  else
    push_loc((this->_init_value)
	     ? (this->_convert)
	       ? (this->_convert)(Eval(this->_init_value))
	       : Eval(this->_init_value)
	     : 0);

  return 0;
}

void Init_Declaration()
{
  declaration_inherit_instruction_function_vector._Eval =
    (EvalFct) Declaration__Eval;
}
