
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Control.h"

static inherit_instruction_function_vector
  control_inherit_instruction_function_vector;

Control * Control__Control(type)
     JMP_TYPE type;
{
  Control * this = (Control *) Malloc(sizeof(Control));

  Instruction_Constructor
    (control_inherit_instruction_function_vector, this, Type_Void);

  this->_type = type;

  return this;
}

static Object Control__Eval(this)
     Control * this;
{
  longjmp(current_env, this->_type);
}

void Init_Control()
{
  control_inherit_instruction_function_vector._Eval = (EvalFct) Control__Eval;
}
