
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Const_h
#define _Const_h

#include "Instruction.h"

/* Const : type pure non terminal */

#define Inherit_Const Inherit_Instruction		/* rien de neuf */

#define inherit_const_function_vector	inherit_instruction_function_vector
  
typedef struct _Const {
  Inherit_Instruction;
} Const;
  

/* Int : type terminal */

typedef struct {
  Inherit_Const;

  int _value;
} Int;

extern FCT( Int *, Int__Int,(int) );
     
void Init_Int();


/* Char : type terminal */

typedef struct {
  Inherit_Const;

  char _value;
} Char;

extern FCT( Char *, Char__Char,(int) );
     
void Init_Char();

     
/* Char * : type terminal */

typedef struct {
  Inherit_Const;

  char * _value;
} String;

extern FCT( String *, String__String,(char *) );
     
void Init_String();

#endif

