
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <stdio.h>

#include "Const.h"
#include "Type.h"


/* Int */

static inherit_const_function_vector int_inherit_const_function_vector;

Int * Int__Int(value)
     int value;
{
  Int * this = (Int *) Malloc(sizeof(Int));

  Const_Constructor(int_inherit_const_function_vector, this, Type_Int);
  
  this->_value = value;

  return this;
}
  
static Object Int__Eval(this)
     Int * this;
{
  return this->_value;
}

void Init_Int()
{
  int_inherit_const_function_vector._Eval = (EvalFct) Int__Eval;
}


/* Char */

static inherit_const_function_vector char_inherit_const_function_vector;

Char * Char__Char(value)
     int value;
{
  Char * this = (Char *) Malloc(sizeof(Char));

  Const_Constructor(char_inherit_const_function_vector, this, Type_Char);
  
  this->_value = (char) value;

  return this;
}
  
static Object Char__Eval(this)
     Char * this;
{
  return this->_value;
}

void Init_Char()
{
  char_inherit_const_function_vector._Eval = (EvalFct) Char__Eval;
}


/* String */

static inherit_const_function_vector string_inherit_const_function_vector;

String * String__String(value)
     char * value;
{
  String * this = (String *) Malloc(sizeof(String));

  Const_Constructor(string_inherit_const_function_vector, this, Type_String);
  
  this->_value = value;

  return this;
}
  
static Object String__Eval(this)
     String * this;
{
  return (Object) this->_value;
}

void Init_String()
{
  string_inherit_const_function_vector._Eval = (EvalFct) String__Eval;
}
  
