
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Comma.h"
#include "stack.h"

static inherit_instruction_function_vector
  commaexpression_inherit_instruction_function_vector;

CommaExpression * CommaExpression__CommaExpression(discarded, last, ndisc)
     Instruction ** discarded;
     Instruction * last;
     int ndisc;
{
  CommaExpression * this = (CommaExpression *) Malloc(sizeof(CommaExpression));
  
  Instruction_Constructor
    (commaexpression_inherit_instruction_function_vector,
     this, (last) ? GetExprType(last) : Type_Void);
       
  this->_discarded = discarded;
  this->_last = last;
  this->_n_discarded = ndisc;

  return this;
}

static Object CommaExpression__Eval(this)
     CommaExpression * this;
{
  if (this->_last) {
    Instruction ** p = this->_discarded;
    Instruction ** l = p + this->_n_discarded;
#ifdef object_sur_plus_d_un_mot
    Object * stackpointer = Stack_Pointer;
#endif
    
    while (p != l) {
      Eval(*p);
      p += 1;
#ifdef object_sur_plus_d_un_mot
      Stack_Pointer = stackpointer;
#endif
    }
    
    return Eval(this->_last);
  }
  else
    return 0;
}

void Init_CommaExpression()
{
  commaexpression_inherit_instruction_function_vector._Eval =
    (EvalFct) CommaExpression__Eval;
}
