
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include "Cast.h"

/* Cast

   Utilise lorsqu'il y a une fonction de conversion
   */

static inherit_instruction_function_vector
  cast_inherit_instruction_function_vector;

Cast * Cast__Cast(expr, desiredtype, convert)
     Instruction * expr;
     Type * desiredtype;
     ConvFct convert;
{
  Cast * this = (Cast *) Malloc(sizeof(Cast));

  Instruction_Constructor
    (cast_inherit_instruction_function_vector, this, desiredtype);

  this->_expr = expr;
  this->_convert = (convert == AlreadyConvertible) ? 0 : convert;

  return this;
}

static Object Cast__Eval(this)     
     Cast * this;
{
  return  (this->_convert)
    ? (this->_convert)(Eval(this->_expr))
    : /* il s'agit d'un cast sur une fonction ou variable pour lesquels
	 il ne faut pas faire d'effet de bord sur le type memorise (voir
	 cast.c) on rend simplement la valeur */
      Eval(this->_expr);
}



void Init_Cast()
{
  cast_inherit_instruction_function_vector._Eval = (EvalFct) Cast__Eval;
}
