
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _Builtin_h
#define _Builtin_h

#include "Function.h"
#include "hash.h"

extern Function * Builtin_Not;
extern Function * Builtin_Mono_Minus;
extern Function * Builtin_Complement;

extern Function * Builtin_egal;
extern Function * Builtin_negal;

extern Function * Builtin_cond_and;
extern Function * Builtin_cond_or;

extern HashTable * binary_oper_hashtable;
extern HashTable * binary_unique_oper_hashtable;
extern HashTable * binary_special_oper_hashtable;

extern HashTable * builtin_fct_nbre_arg_min;

extern HashTable * binary_modifoper_hashtable;

extern FCT(int, check_strlen,(char *)	);
extern FCT(Object, new_builtin,(char *, Type *, int, Type **,
				FCT (Object, (*fct),(Instruction **))) );

extern void Init_Builtin();

#ifdef XCORAL
extern FCT(void, stop_profile,()	);
extern FCT(void, rerun_profile,()	);
#endif

#endif
