
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#include <stdio.h>

#include "Block.h"
#include "Type.h"
#include "stack.h"

static inherit_instruction_function_vector
  block_inherit_instruction_function_vector;

Block * Block__Block(nexpr, instrs)
     int nexpr;
     Instruction ** instrs;
{
  Block * this = (Block *) Malloc(sizeof(Block));

  Instruction_Constructor
    (block_inherit_instruction_function_vector, this, Type_Void);
  
  this->_nexpr = nexpr;
  this->_instrs = instrs;

  return this;
}

static Object Block__Eval(this)
     Block * this;
{
  Instruction ** pi = this->_instrs;
  Instruction ** pli = pi + this->_nexpr;
  Object * stackpointer = Stack_Pointer;

  {
#ifdef object_sur_plus_d_un_mot
    Object * stackp = Stack_Pointer;
#endif
    
    while (pi != pli) {
      Eval(*pi);
      pi += 1;
#ifdef object_sur_plus_d_un_mot
      Stack_Pointer = stackp;
#endif
    }
  }

  Stack_Pointer = stackpointer;
    
  return 0;
}

void Init_Block()
{
  block_inherit_instruction_function_vector._Eval = (EvalFct) Block__Eval;
}
