
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/


#ifndef _ArrayAccess_h
#define _ArrayAccess_h

#include "Instruction.h"

typedef struct {
  Inherit_Instruction;

  Instruction * _array;
  Instruction * _index;
  int _subsize;
  FCT( Object,(* _access),(Object, Object, int)	);
} ArrayAccess;

extern FCT( ArrayAccess *,ArrayAccess__ArrayAccess,
	   			(Instruction *, Instruction *)	);

typedef struct {
  Inherit_Instruction;

  Instruction * _array;
  Instruction * _index;
  Instruction * _value;
  FCT( Object,(* _convert),(Object));
  FCT( Object,(* _affect),(Object, Object, Object)	);
} ArrayAssignment;

extern FCT( ArrayAssignment *,ArrayAssignment__ArrayAssignment,
	   	(Instruction *, Instruction *, Instruction *,
		 Type *, FCT2( Object,(*),(Object)))	);


typedef struct {
  Inherit_Instruction;

  Instruction * _array;
  Instruction * _index;
  Instruction * _value;
  FCT( Object,(* _convert),(Object)			);
  FCT( Object,(* _affect),(Object, Object, Object)	);
  FCT( Object,(* _access),(Object, Object)		);
  FCT( Object,(* _bfct),(Object, Object, int)		);
  int _size;
} ArrayModify;

extern FCT( ArrayModify *,ArrayModify__ArrayModify,
	   	(Instruction *, Instruction *, Instruction *,
		 FCT2( Object,(*),(Object, Object, int)),
		 Type *, FCT2( Object,(*),(Object)))	);


typedef struct {
  Inherit_Instruction;

  Instruction * _array;
  Instruction * _index;
  int _subsize;
} ArrayRef;

extern FCT( ArrayRef *,ArrayRef__ArrayRef,(Instruction *, Instruction *)   );

typedef struct {
  Inherit_Instruction;

  Instruction * _array;
  Instruction * _index;
  int _value;
  FCT( Object,(* _convert),(Object)			);
  FCT( Object,(* _affect),(Object, Object, Object)	);
  FCT( Object,(* _access),(Object, Object)		);
  FCT( Object,(* _bfct),(Object, Object, int)		);
  int _size;
} ArrayPostIncrDecr;

extern FCT( ArrayPostIncrDecr *,ArrayPostIncrDecr__ArrayPostIncrDecr,
	   	(Instruction *, Instruction *, int,
		 FCT2( Object,(*),(Object, Object, int)),
		 Type *, FCT2( Object,(*),(Object)))	);


/**/

extern void Init_Array();

#endif
