/* MiscSpaceMouseFrontend.m				 
 *
 * This object deals with get GUI we need to do all the settings.
 * It does not really handle the data. It only controls the views and
 * graphical controls and work with the main MiscSwapView.
 *
 * For interface-info see the header file. The comments in this file mostly
 * cover only the real implementation details.
 *
 * Written by: 		Thomas Engel
 * Created:    		09.04.1994 (Copyleft)
 * Last modified: 	15.04.1994
 */

#import "MiscSpaceMouseFrontend.h"
#import "MiscSpaceMouseDriver.h"

@implementation MiscSpaceMouseFrontend

- revert:sender
{
	[super revert:sender];
	
	if( !view )
	{
		if( [NXApp loadNibSection:"MiscSpaceMouse.nib" owner:self] == nil )
		NXRunAlertPanel( NULL, "Couldn't load MiscSpaceMouse.nib",
						 "OK", NULL, NULL);
	}
	[mouseDriver setFrontend:self];

	// Let's init all the default data.
	
	if( [mouseDriver isConnectedToDevice] )
	{
		[privateSwapView setContentView:settingsView];
		[[NXApp delegate] setMouse:mouseDriver];		// BUGGY ! NASTY !
	}
	else
		[privateSwapView setContentView:connectView];
	
	return self;
}

- usePortA:sender
{
	[portField setEditable:NO];
	[portField setStringValue:"/dev/cufa"];
	return self;
}

- usePortB:sender
{
	[portField setEditable:NO];
	[portField setStringValue:"/dev/cufb"];
	return self;
}

- useCustomPort:sender
{
	[portField setEditable:YES];
	[portField setStringValue:"/dev/?"];
	return self;
}

- connect:sender
{
	if( [mouseDriver connectToDevice:[portField stringValue]] )
	{
		[privateSwapView setContentView:settingsView];
		[[NXApp delegate] setMouse:mouseDriver];		// BUGGY ! NASTY !
	}
	return self;
}

- disconnect:sender
{
	[mouseDriver disconnectFromDevice];
	[privateSwapView setContentView:connectView];

	return self;
}

- takeTransModeFrom:sender
{
	if( sender == mouseDriver )
		[transModeSwitch setState:[sender hasTranslationEnabled]];
		
	else
		[mouseDriver setMouseInDominantMode:[mouseDriver isInDominantMode] 
		  			 withTranslationEnabled:[sender state]
	      			 andRotationEnabled:[mouseDriver hasRotationEnabled]];
	return self;
}

- takeRotModeFrom:sender
{
	if( sender == mouseDriver )
		[rotModeSwitch setState:[sender hasRotationEnabled]];
		
	else
		[mouseDriver setMouseInDominantMode:[mouseDriver isInDominantMode] 
		  			 withTranslationEnabled:[mouseDriver hasTranslationEnabled]
	      			 andRotationEnabled:[sender state]];
	return self;
}

- takeDomModeFrom:sender
{
	if( sender == mouseDriver )
		[domModeSwitch setState:[sender isInDominantMode]];
		
	else
		[mouseDriver setMouseInDominantMode:[sender state] 
		  			 withTranslationEnabled:[mouseDriver hasTranslationEnabled]
	      			 andRotationEnabled:[mouseDriver hasRotationEnabled]];
	return self;
}

- takeRotQualityFrom:sender
{
	int	anInt;
	
	if( sender == mouseDriver )
	{
		anInt = [sender rotationQuality];
		[rotQualitySlider setIntValue:anInt];
		[rotQualityField setIntValue:anInt];
	}	
	else
		[mouseDriver setQualityForTranslation:[mouseDriver translationQuality]
					 andRotation:[sender intValue]];		
	return self;
}

- takeTransQualityFrom:sender
{
	int	anInt;
	
	if( sender == mouseDriver )
	{
		anInt = [sender translationQuality];
		[transQualitySlider setIntValue:anInt];
		[transQualityField setIntValue:anInt];
	}	
	else
		[mouseDriver setQualityForTranslation:[sender intValue]
					 andRotation:[mouseDriver rotationQuality]];		
	return self;
}

- takeScaleFrom:sender
{
	float	scale;
	float	ration;

	if( sender == mouseDriver )
	{
		scale = [sender rotScale];
		ration = [sender transScale] / scale;
		[scaleSlider setFloatValue:scale];
		[scaleField setFloatValue:scale];
	}	
	else
	{
		scale = [sender floatValue];
		ration = [scaleRationSlider floatValue];

		[mouseDriver setRotScale:scale];
		[mouseDriver setTransScale:scale * ration];
	}	
	return self;
}

- takeScaleRationFrom:sender
{
	float	scale;
	float	ration;
	
	if( sender == mouseDriver )
	{
		scale = [sender rotScale];
		ration = [sender transScale] / scale;
		[scaleRationSlider setFloatValue:ration];
		[scaleRationField setFloatValue:ration];
	}	
	else
	{
		scale = [scaleSlider floatValue];
		ration = [sender floatValue];

		[mouseDriver setTransScale:scale * ration];
	}	
	return self;
}

- takeNullRadiusFrom:sender
{
	int	anInt;
	
	if( sender == mouseDriver )
	{
		anInt = [sender nullRadius];
		[nullRadiusSlider setIntValue:anInt];
		[nullRadiusField setIntValue:anInt];
	}	
	else
		[mouseDriver setNullRadius:[sender intValue]];	
			
	return self;
}

- takeMinDataRateFrom:sender
{
	int	anInt;
	
	if( sender == mouseDriver )
	{
		anInt = [sender minDataRate];
		[minDataRateSlider setIntValue:anInt];
		[minDataRateField setIntValue:anInt];
	}	
	else
		[mouseDriver setDataRateMin:[sender intValue]
					 max:[mouseDriver maxDataRate]];		
	return self;
}

- takeMaxDataRateFrom:sender
{
	int	anInt;
	
	if( sender == mouseDriver )
	{
		anInt = [sender maxDataRate];
		[maxDataRateSlider setIntValue:anInt];
		[maxDataRateField setIntValue:anInt];
	}	
	else
		[mouseDriver setDataRateMin:[mouseDriver minDataRate]
					 max:[sender intValue]];		
	return self;
}

@end

/*
 * History: 15.04.94 All the settings should work now.
 *
 *			09.04.94 First codeing done.
 *
 *
 * Bugs: - Not very likely.
 */