/* Misc3DDeviceDriver.m				 
 *
 * This is a very simple class. It only implements the very basic methods in
 * a very simple style. This is the minimum a driver has to support to be
 * a 3DDevice driver. 
 *
 * For more interface-info see the header file. More in depth information
 * can be found in the source-code.
 *
 * Written by: 		Thomas Engel
 * Created:    		10.04.1994 (Copyleft)
 * Last modified: 	10.04.1994
 */

#import "Misc3DDeviceDriver.h"

@implementation Misc3DDeviceDriver

- init
{
	self = [super init];
	if( !self ) return self;

	// Ok, we did pass the risky point. So lets do our default settings.
	
	sendEvents = NO;
	syncEvents = YES;
	
	return self;
}

- setTarget:anObject
{
	target = anObject;
	if( target == nil ) [self disableEvents];
	
	return self;
}

- target
{
	return target;
}

- realDriver
{
	return self;
}

- (oneway void)enableEvents
{
	sendEvents = YES;
	awaitingSync = NO;
	return;
}

- (oneway void)disableEvents
{
	sendEvents = NO;
	return;
}

- (oneway void)syncEvents
{
	awaitingSync = NO;
	return;
}

- setUseExternalSync:(BOOL)aFlag
{
	syncEvents = aFlag;
	return self;
}

- (BOOL)doesUseExternalSync
{
	return syncEvents;
}

- (BOOL)areEventsEnabled
{
	return sendEvents;
}

@end

/*
 * History: 10.04.94 First code placed here.  
 *
 *
 * Bugs: no
 */