/* Misc3DDeviceDriver.h				 
 *
 * This is a very simple class. It only implements the very basic methods in
 * a very simple style. This is the minimum a driver has to support to be
 * a 3DDevice driver. 
 *
 * Usage: You should not have to worry about this class. It might just be
 *		  serve as the super-calss for any other driver category.
 *
 * Notes: Setting the target to nil will disable the events.
 *
 * Written by: 		Thomas Engel
 * Created:    		10.04.1994 (Copyleft)
 * Last modified: 	10.04.1994
 */

#import "appkit/appkit.h"
#import "3Dkit/3Dkit.h"

// The following protocol defines all the methods a 3DDriver should implement.
// If you are a subclass of this abstract driver you don't have to deal with
// the realDriver method.
// If you prefer not being a subclass you have to return self from the
// realDriver method!
// If you want to check a target before using it; add the check to your 
// private setTarget: method.
// 
// The setTarget method may also be used to find the point when a driver will
// be deactivated. setTarget:nil will deactivate a driver. If it does
// return nil it won't be deactivated!!! Please don't use this feature unless
// there is a absolute need for it!
// But it is recommended to use the setTarget method for any kind of necessary
// device inits-updates when in becomes active or idle. (see the 
// MiscSpaceMouseDriver for a useful example.

@protocol Misc3DDeviceDriverProtocol

- setTarget:anObject;
- target;
- realDriver;

- (oneway void)enableEvents;
- (oneway void)disableEvents;
- (oneway void)syncEvents;

- setUseExternalSync:(BOOL)aFlag;
- (BOOL)doesUseExternalSync;
- (BOOL)areEventsEnabled;

@end 

@interface Misc3DDeviceDriver:Object <Misc3DDeviceDriverProtocol>
{
	id		target;
	BOOL	sendEvents;
	BOOL	syncEvents;
	BOOL	awaitingSync;
}

// In our init we set the default to syncing the events. If you don't like it
// Change it for your subclass.

- init;

@end

/*
 * History: 10.04.94 First code placed here.  
 *
 *
 * Bugs: no
 */